/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::directionMixedFvPatchgpuField

Group
    grpGenericBoundaryConditions

Description
    Base class for direction-mixed boundary conditions.

SourceFiles
    directionMixedFvPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef directionMixedFvPatchgpuField_H
#define directionMixedFvPatchgpuField_H

#include "transformFvPatchgpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                  Class directionMixedFvPatchgpuField Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class directionMixedFvPatchgpuField
:
    public transformFvPatchgpuField<Type>
{
    // Private data

        //- Value field
        gpuField<Type> refValue_;

        //- Normal gradient field
        gpuField<Type> refGrad_;

        //- Fraction (0-1) of value used for boundary condition
        symmTensorgpuField valueFraction_;


public:

    //- Runtime type information
    TypeName("directionMixed");


    // Constructors

        //- Construct from patch and internal field
        directionMixedFvPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        directionMixedFvPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given directionMixedFvPatchgpuField onto
        //  a new patch
        directionMixedFvPatchgpuField
        (
            const directionMixedFvPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchgpuField<Type>> clone() const
        {
            return tmp<fvPatchgpuField<Type>>
            (
                new directionMixedFvPatchgpuField<Type>(*this)
            );
        }

        //- Construct as copy setting internal field reference
        directionMixedFvPatchgpuField
        (
            const directionMixedFvPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchgpuField<Type>>
            (
                new directionMixedFvPatchgpuField<Type>(*this, iF)
            );
        }


    // Member functions

        // Attributes

            //- Return true: this patch field fixes a value.
            //  Needed to check if a level has to be specified while solving
            //  Poissons equations.
            virtual bool fixesValue() const
            {
                return true;
            }

            //- Return false: this patch field is not altered by assignment
            virtual bool assignable() const
            {
                return false;
            }


        // Mapping functions

            //- Map (and resize as needed) from self given a mapping object
            virtual void autoMap
            (
                const fvPatchgpuFieldMapper&
            );

            //- Reverse map the given fvPatchgpuField onto this fvPatchgpuField
            virtual void rmap
            (
                const fvPatchgpuField<Type>&,
                const labelgpuList&
            );


        // Return defining fields

            virtual gpuField<Type>& refValue()
            {
                return refValue_;
            }

            virtual const gpuField<Type>& refValue() const
            {
                return refValue_;
            }

            virtual gpuField<Type>& refGrad()
            {
                return refGrad_;
            }

            virtual const gpuField<Type>& refGrad() const
            {
                return refGrad_;
            }

            virtual symmTensorgpuField& valueFraction()
            {
                return valueFraction_;
            }

            virtual const symmTensorgpuField& valueFraction() const
            {
                return valueFraction_;
            }


        // Evaluation functions

            //- Return gradient at boundary
            virtual tmp<gpuField<Type>> snGrad() const;

            //- Evaluate the patch field
            virtual void evaluate
            (
                const Pstream::commsTypes commsType =
                    Pstream::commsTypes::blocking
            );

            //- Return face-gradient transform diagonal
            virtual tmp<gpuField<Type>> snGradTransformDiag() const;


        //- Write
        virtual void write(Ostream&) const;


    // Member operators

        virtual void operator=(const fvPatchgpuField<Type>&) {}
        virtual void operator+=(const fvPatchgpuField<Type>&) {}
        virtual void operator-=(const fvPatchgpuField<Type>&) {}
        virtual void operator*=(const fvPatchgpuField<Type>&) {}
        virtual void operator/=(const fvPatchgpuField<Type>&) {}

        virtual void operator=(const Field<Type>&) {}
        virtual void operator=(const gpuField<Type>&) {}
        virtual void operator+=(const gpuField<Type>&) {}
        virtual void operator-=(const gpuField<Type>&) {}
        virtual void operator*=(const gpuField<scalar>&) {}
        virtual void operator/=(const gpuField<scalar>&) {}

        virtual void operator=(const Type&) {}
        virtual void operator+=(const Type&) {}
        virtual void operator-=(const Type&) {}
        virtual void operator*=(const scalar) {}
        virtual void operator/=(const scalar) {}
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "directionMixedFvPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
