/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvcReconstruct.H"
#include "gpufvMesh.H"
#include "volgpuFields.H"
#include "surfacegpuFields.H"
#include "gpufvcSurfaceIntegrate.H"
#include "extrapolatedCalculatedFvPatchgpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fvc
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<vector,Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
reconstruct
(
    const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>& ssf
)
{
    typedef typename outerProduct<vector, Type>::type GradType;

    const gpufvMesh& mesh = ssf.mesh();

    surfaceVectorgpuField SfHat(mesh.Sf()/mesh.magSf());

    tmp<GeometricgpuField<GradType, fvPatchgpuField, gpuvolMesh>> treconField
    (
        new GeometricgpuField<GradType, fvPatchgpuField, gpuvolMesh>
        (
            IOobject
            (
                "volIntegrate("+ssf.name()+')',
                ssf.instance(),
                mesh.hostmesh(),
                IOobject::NO_READ,
                IOobject::NO_WRITE
            ),
            inv(surfaceSum(SfHat*mesh.Sf()))&surfaceSum(SfHat*ssf),
            extrapolatedCalculatedFvPatchgpuField<GradType>::typeName
        )
    );

    treconField.ref().correctBoundaryConditions();

    return treconField;
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<vector, Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
reconstruct
(
    const tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>& tssf
)
{
    typedef typename outerProduct<vector, Type>::type GradType;
    tmp<GeometricgpuField<GradType, fvPatchgpuField, gpuvolMesh>> tvf
    (
        fvc::reconstruct(tssf())
    );
    tssf.clear();
    return tvf;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fvc

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
