/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::LduInterfaceField

Description
    An abstract base class for implicitly-coupled interface fields
    e.g. processor and cyclic patch fields.

SourceFiles
    LduInterfaceField.C

\*---------------------------------------------------------------------------*/

#ifndef LduInterfacegpuField_H
#define LduInterfacegpuField_H

#include "lduInterfacegpuField.H"
#include "primitiveFieldsFwd.H"
#include "Pstream.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// Forward declarations
class gpulduMatrix;

/*---------------------------------------------------------------------------*\
                     Class LduInterfaceField Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class LduInterfacegpuField
:
    public lduInterfacegpuField
{
    // Private Member Functions

        //- No copy construct
        LduInterfacegpuField(const LduInterfacegpuField&) = delete;

        //- No copy assignment
        void operator=(const LduInterfacegpuField&) = delete;


public:

    //- Runtime type information
    TypeName("LduInterfacegpuField");


    // Constructors

        //- Construct given coupled patch
        LduInterfacegpuField(const gpulduInterface& patch)
        :
            lduInterfacegpuField(patch)
        {}


    //- Destructor
    virtual ~LduInterfacegpuField() = default;


    // Member Functions

        // Coupled interface functionality

            //- Inherit initInterfaceMatrixUpdate from lduInterfaceField
            using lduInterfacegpuField::initInterfaceMatrixUpdate;

            //- Initialise neighbour matrix update
            virtual void initInterfaceMatrixUpdate
            (
                gpuField<Type>&,
                const bool add,
                const gpulduAddressing&,
                const label interfacei,
                const gpuField<Type>&,
                const scalargpuField&,
                const Pstream::commsTypes commsType
            ) const
            {}

            //- Inherit updateInterfaceMatrix from lduInterfaceField
            using lduInterfacegpuField::updateInterfaceMatrix;

            //- Update result field based on interface functionality
            virtual void updateInterfaceMatrix
            (
                gpuField<Type>&,
                const bool add,
                const gpulduAddressing&,
                const label interfacei,
                const gpuField<Type>&,
                const scalargpuField&,
                const Pstream::commsTypes commsType
            ) const = 0;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
