/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
    Copyright (C) 2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Namespace
    Foam::constant::physicoChemical

Description
    Physico-chemical constants

\*---------------------------------------------------------------------------*/

#ifndef gpuphysicoChemicalConstants_H
#define gpuphysicoChemicalConstants_H

#include "scalar.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace constant
{
namespace physicoChemical
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

    //- Universal gas constant: default SI units: [J/mol/K]
    __constant__  scalar gR;

    //- Faraday constant: default SI units: [C/mol]
    __constant__  scalar gF;

    //- Stefan-Boltzmann constant: default SI units: [W/m2/K4]
    __constant__  scalar gsigma;

    //- Wien displacement law constant: default SI units: [m.K]
    __constant__  scalar gb;

    //- First radiation constant: default SI units: [W/m2]
    __constant__  scalar gc1;

    //- Second radiation constant: default SI units: [m.K]
    __constant__  scalar gc2;

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace physicoChemical
} // End namespace constant
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
