/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "alphatWallFunctionFvPatchScalargpuField.H"
#include "compressibleTurbulenceModel.H"
#include "fvPatchgpuFieldMapper.H"
#include "volgpuFields.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace compressible
{

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

alphatWallFunctionFvPatchScalargpuField::alphatWallFunctionFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(p, iF),
    Prt_(0.85)
{}


alphatWallFunctionFvPatchScalargpuField::alphatWallFunctionFvPatchScalargpuField
(
    const alphatWallFunctionFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedValueFvPatchScalargpuField(ptf, p, iF, mapper),
    Prt_(ptf.Prt_)
{}


alphatWallFunctionFvPatchScalargpuField::alphatWallFunctionFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedValueFvPatchScalargpuField(p, iF, dict),
    Prt_(dict.getOrDefault<scalar>("Prt", 0.85))
{}


alphatWallFunctionFvPatchScalargpuField::alphatWallFunctionFvPatchScalargpuField
(
    const alphatWallFunctionFvPatchScalargpuField& awfpsf
)
:
    fixedValueFvPatchScalargpuField(awfpsf),
    Prt_(awfpsf.Prt_)
{}


alphatWallFunctionFvPatchScalargpuField::alphatWallFunctionFvPatchScalargpuField
(
    const alphatWallFunctionFvPatchScalargpuField& awfpsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(awfpsf, iF),
    Prt_(awfpsf.Prt_)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void alphatWallFunctionFvPatchScalargpuField::updateCoeffs()
{
    if (updated())
    {
        return;
    }

    const label patchi = patch().index();

    // Retrieve turbulence properties from model
    const compressibleTurbulenceModel& turbModel =
        db().lookupObject<compressibleTurbulenceModel>
        (
            IOobject::groupName
            (
                compressibleTurbulenceModel::propertiesName,
                internalField().group()
            )
        );

    const scalargpuField& rhow = turbModel.rho().boundaryField()[patchi];
    const tmp<scalargpuField> tnutw = turbModel.nut(patchi);

    operator==(rhow*tnutw/Prt_);

    fixedValueFvPatchScalargpuField::updateCoeffs();
}


void alphatWallFunctionFvPatchScalargpuField::write(Ostream& os) const
{
    fvPatchgpuField<scalar>::write(os);
    os.writeEntry("Prt", Prt_);
    writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

makePatchTypeField
(
    fvPatchScalargpuField,
    alphatWallFunctionFvPatchScalargpuField
);

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace compressible
} // End namespace Foam

// ************************************************************************* //
