/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Typedef
    Foam::diagTensorField

Description
    Specialisation of Field\<T\> for diagTensor.

SourceFiles
    diagTensorField.C

\*---------------------------------------------------------------------------*/

#ifndef diagTensorField_H
#define diagTensorField_H

#include "tensorField.H"
#include "diagTensor.H"

#define TEMPLATE
#include "FieldFunctionsM.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

typedef Field<diagTensor> diagTensorField;

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

UNARY_FUNCTION(diagTensor, tensor, diag)
UNARY_FUNCTION(scalar, diagTensor, tr)
UNARY_FUNCTION(sphericalTensor, diagTensor, sph)
UNARY_FUNCTION(scalar, diagTensor, det)
UNARY_FUNCTION(diagTensor, diagTensor, inv)


BINARY_OPERATOR(tensor, diagTensor, tensor, +, add)
BINARY_OPERATOR(tensor, diagTensor, tensor, -, subtract)

BINARY_TYPE_OPERATOR(tensor, diagTensor, tensor, +, add)
BINARY_TYPE_OPERATOR(tensor, diagTensor, tensor, -, subtract)

BINARY_OPERATOR(vector, vector, diagTensor, /, divide)
BINARY_TYPE_OPERATOR(vector, vector, diagTensor, /, divide)


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "undefFieldFunctionsM.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
#define TEMPLATE
#include "gpuFieldFunctionsM.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
namespace Foam
{

typedef gpuField<diagTensor> diagTensorgpuField;

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

UNARY_FUNCTION(diagTensor, tensor, diag)
UNARY_FUNCTION(scalar, diagTensor, tr)
UNARY_FUNCTION(sphericalTensor, diagTensor, sph)
UNARY_FUNCTION(scalar, diagTensor, det)
UNARY_FUNCTION(diagTensor, diagTensor, inv)

BINARY_SYM_OPERATOR(diagTensor, scalar, diagTensor, *, outer)
BINARY_SYM_FUNCTION(diagTensor, scalar, diagTensor, multiply)
BINARY_OPERATOR(diagTensor, diagTensor, scalar, /, divide)
BINARY_TYPE_OPERATOR_FS(diagTensor, diagTensor, scalar, /, divide)

BINARY_FULL_OPERATOR(diagTensor, diagTensor, diagTensor, +, add)
BINARY_FULL_OPERATOR(diagTensor, diagTensor, diagTensor, -, subtract)
BINARY_FULL_OPERATOR(diagTensor, diagTensor, diagTensor, &, dot)
BINARY_FULL_OPERATOR(vector, vector, diagTensor, /, divide)
BINARY_FULL_OPERATOR(diagTensor, scalar, diagTensor, /, divide)

BINARY_SYM_OPERATOR(tensor, diagTensor, tensor, +, add)
BINARY_SYM_OPERATOR(tensor, diagTensor, tensor, -, subtract)
BINARY_SYM_OPERATOR(tensor, diagTensor, tensor, &, dot)
BINARY_SYM_OPERATOR(vector, diagTensor, vector, &, dot)


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

extern template class gpuList<diagTensor>;
extern template class gpuField<diagTensor>;

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "undefgpuFieldFunctionsM.H"

#endif

// ************************************************************************* //
