#pragma once

#include <stdio.h>
#include <type_traits>
#include<hip/hip_runtime.h>

#define HIP_CALL(x) do { if((x) != hipSuccess) {           \
 printf("Error at %s:%d\n",__FILE__,__LINE__);             \
 printf("%s\n",hipGetErrorString(hipPeekAtLastError()));   \
 hipDeviceReset();                                         \
 ::exit(static_cast<int>(hipPeekAtLastError()));           \
 }} while(0)

#define GPU_ERROR_CHECK()                                  \
 hipDeviceSynchronize();                                   \
 HIP_CALL( hipPeekAtLastError());

#define GPU_ERROR_CHECK_ASYNC()                            \
 HIP_CALL(hipPeekAtLastError());

namespace Foam
{
    int deviceCount();
    int currentDevice();
    void setCurrentDevice(int device);
    int deviceComputeCapability(int device);
    int currentComputeCapability();
    bool needTextureBind();
    
    template<class T>
    bool hasAtomicAdd();

    template<class T>
    struct is_number: std::false_type {};
}

#include "DeviceConfigI.H"

