/*******************************************************************************************
 * This file contains all the parameters and function declarations related to thermophysical
 * properties, which are implemented in thermoFluid.cpp.
 ******************************************************************************************/

#ifndef _THERMOFLUID_H
#define _THERMOFLUID_H

#include "common.h"

class thermoFluid_d
{
public:

    thermo_ptr thermo_ptr_h;
    thermo_ptr thermo_ptr_d;

    thermoFluid_d(thermo_ptr *thermo_ptr_d_ref);
    ~thermoFluid_d();

    /** Construct class thermoFluid_d.
     *  
     *  \param[in] sp_num          The number of species. (host)
     *  \param[in] size            Number of grid points. (host)
     *  \param[in] thermo_ptr_ref  The memory address of the host side corresponding to 
     *                             the packaged storage thermo parameters. (host)
     *  \param[in] op              Data processing mode, see THERMO_SET_MODE for more. (host) 
     */
    void thermoFluid_d_set(int sp_num, int size, thermo_ptr *thermo_ptr_ref, THERMO_SET_MODE op);

    /** Query the thermo_ptr_d.
     *  
     *  \param[in] thermo_ptr_h  The memory address of the host side corresponding to 
     *                           the packaged storage thermo parameters. (host)
     *  \param[in] op            Data processing mode, see THERMO_SET_MODE for more. (host) 
     */
    void thermoFluid_d_get(thermo_ptr *thermo_ptr_h, THERMO_SET_MODE op);

    /** Update X from Y or update Y from X.
     *  \param[in] op            Data processing mode, see UPDATE_FRAC_MODE for more. (host) 
     */
    void thermoFluid_update_fraction(UPDATE_FRAC_MODE op);

    void thermoFluid_compute_ha_cp();

    void thermoFluid_compute_hc_mass();

    void thermoFluid_get_rho_c();

    void thermoFluid_get_psi();

    void thermoFluid_update_c_from_TP();

    void thermoFluid_update_TP_from_c();

    void thermoFluid_set_state_TPY();

    void thermoFluid_set_state_hPY();

    void thermoFluid_h_constraint();

    void thermoFluid_c_constraint();

    void set_TPY(REAL *T, REAL *P, REAL *Y, int sp_num, int size, DATA_MODE op);

    void get_Y(REAL *Y, int sp_num, int size, DATA_MODE op);

    REAL *T_origin = nullptr;
    REAL *P_origin = nullptr;
    REAL *Y_origin = nullptr;

    int size_origin = 0;
};

/** Global variables for thermoFluid_d class types.
 */
extern thermoFluid_d *thermoFluid_d_ptr;

#endif //_THERMOFLUID_H