/*******************************************************************************************
 * This file contains the declarations of GPU kernels related to reactions compute.
 ******************************************************************************************/

#ifndef _REACTIONS_KERNEL_H
#define _REACTIONS_KERNEL_H

#include "common.h"

void compute_T_P_h(REAL *c, REAL *T, REAL *P);

void compute_B_h(REAL *T, REAL *T_range, REAL *sp_nasa, REAL *B);

void compute_kf_kr_h(REAL *abe, REAL *T, REAL *v_net, REAL *is_rev, REAL *B, REAL *kf, REAL *kr, REAL *kf_low);

void compute_react_c_h(REAL *tb_coeffs, REAL *c, REAL *T, REAL *kf, REAL *kr, REAL *kf_low, REAL *react_c, 
    REAL *react_type, REAL *fall_type, REAL *fall_coeffs, REAL *vr, REAL *vf, REAL *is_rev, REAL *q);

void compute_dTdt_h(REAL *v_net, REAL *q, REAL *sp_ha_mole, REAL *sp_cp_mole, REAL *sp_net_rate, REAL *c, REAL *dcdt);

#endif //_REACTIONS_KERNEL_H