/*******************************************************************************************
 * This file contains all the parameters and function declarations related to reactions,
 * which are implemented in reactions.cpp.
 ******************************************************************************************/

#ifndef _REACTION_H
#define _REACTION_H

#include "jacobian.h"

class reactions_d: public jacobian_d
{
public:

    reactions_d(reactions_ptr *reactions_ptr_d_ref);
    ~reactions_d();

    /** Set class reactions_d.
     *  
     *  \param[in] react_num          chemical reaction number. (host)
     *  \param[in] reactions_ptr_ref  The memory address of the host side corresponding to 
     *                                the packaged storage reactions parameters. (host)
     *  \param[in] op                 Data processing mode, see THERMO_SET_MODE for more. (host) 
     */
    void reactions_d_set(int react_num, reactions_ptr *reactions_ptr_ref, REACTION_SET_MODE op);

    /** Query class reactions_d.
     *  
     *  \param[in] reactions_ptr_h  The memory address of the host side corresponding to 
     *                              the packaged storage reactions parameters. (host)
     *  \param[in] op               Data processing mode, see THERMO_SET_MODE for more. (host) 
     */
    void reactions_d_get(reactions_ptr *reactions_ptr_h, REACTION_SET_MODE op);

    void cal_react_rate(REAL *y, REAL *dy);
};

/** Global variables for reactions_d class types.
 */
extern reactions_d *reactions_d_ptr;

#endif //_REACTION_H