/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2012 OpenFOAM Foundation
    Copyright (C) 2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "fixedRhoFvPatchScalargpuField.H"
#include "addToRunTimeSelectionTable.H"
#include "fvPatchgpuFieldMapper.H"
#include "volgpuFields.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::fixedRhoFvPatchScalargpuField::fixedRhoFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(p, iF),
    pName_("p"),
    psiName_("thermo:psi")
{}


Foam::fixedRhoFvPatchScalargpuField::fixedRhoFvPatchScalargpuField
(
    const fixedRhoFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedValueFvPatchScalargpuField(ptf, p, iF, mapper),
    pName_(ptf.pName_),
    psiName_(ptf.psiName_)
{}


Foam::fixedRhoFvPatchScalargpuField::fixedRhoFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedValueFvPatchScalargpuField(p, iF, dict),
    pName_(dict.getOrDefault<word>("p", "p")),
    psiName_(dict.getOrDefault<word>("psi", "thermo:psi"))
{}


Foam::fixedRhoFvPatchScalargpuField::fixedRhoFvPatchScalargpuField
(
    const fixedRhoFvPatchScalargpuField& frpsf
)
:
    fixedValueFvPatchScalargpuField(frpsf),
    pName_(frpsf.pName_),
    psiName_(frpsf.psiName_)
{}


Foam::fixedRhoFvPatchScalargpuField::fixedRhoFvPatchScalargpuField
(
    const fixedRhoFvPatchScalargpuField& frpsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(frpsf, iF),
    pName_(frpsf.pName_),
    psiName_(frpsf.psiName_)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::fixedRhoFvPatchScalargpuField::updateCoeffs()
{
    if (updated())
    {
        return;
    }

    const fvPatchgpuField<scalar>& psip =
        patch().lookupPatchField<volScalargpuField, scalar>(psiName_);

    const fvPatchgpuField<scalar>& pp =
        patch().lookupPatchField<volScalargpuField, scalar>(pName_);

    operator==(psip*pp);

    fixedValueFvPatchScalargpuField::updateCoeffs();
}


void Foam::fixedRhoFvPatchScalargpuField::write(Ostream& os) const
{
    fvPatchScalargpuField::write(os);

    os.writeEntryIfDifferent<word>("p", "p", pName_);
    os.writeEntryIfDifferent<word>("psi", "thermo:psi", psiName_);
    writeEntry("value", os);
}

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchScalargpuField,
        fixedRhoFvPatchScalargpuField
    );
}

// ************************************************************************* //
