/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fileFormats::ABAQUSsurfaceFormat

Description
    Abaqus surface reader.

    Output stream options:
       - ASCII only
       - compression on/off

    Output dictionary options: ignored

SourceFiles
    ABAQUSsurfaceFormat.C

\*---------------------------------------------------------------------------*/

#ifndef ABAQUSsurfaceFormat_H
#define ABAQUSsurfaceFormat_H

#include "MeshedSurface.H"
#include "MeshedSurfaceProxy.H"
#include "UnsortedMeshedSurface.H"
#include "ABAQUSsurfaceFormatCore.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace fileFormats
{

/*---------------------------------------------------------------------------*\
              Class fileFormats::ABAQUSsurfaceFormat Declaration
\*---------------------------------------------------------------------------*/

template<class Face>
class ABAQUSsurfaceFormat
:
    public MeshedSurface<Face>,
    public ABAQUSsurfaceFormatCore
{
    // Private Member Functions

        //- Output S3 or S4
        inline static label writeShell
        (
            Ostream& os,
            const Face& f,
            label elemId,       //!< 0-based element Id
            const std::string& elsetName,
            bool header = true
        );


public:

    // Constructors

        //- Default construct
        ABAQUSsurfaceFormat() = default;

        //- Read construct from file name
        explicit ABAQUSsurfaceFormat(const fileName& filename);


    //- Destructor
    virtual ~ABAQUSsurfaceFormat() = default;


    // Static Member Functions

        //- Write surface mesh components by proxy
        static void write
        (
            const fileName& filename,
            const MeshedSurfaceProxy<Face>& surf,
            IOstreamOption streamOpt = IOstreamOption(),
            const dictionary& /*unused*/ = dictionary::null
        );


    // Member Functions

        //- Read from file
        virtual bool read
        (
            const fileName& filename
        );

        //- Write surface mesh to file
        virtual void write
        (
            const fileName& name,
            IOstreamOption streamOpt = IOstreamOption(),
            const dictionary& options = dictionary::null
        ) const
        {
            write(name, MeshedSurfaceProxy<Face>(*this), streamOpt, options);
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fileFormats
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "ABAQUSsurfaceFormat.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
