/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "processorFvsPatchgpuField.H"

// * * * * * * * * * * * * * * * * Constructors * * * * * * * * * * * * * * //

template<class Type>
Foam::processorFvsPatchgpuField<Type>::processorFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    coupledFvsPatchgpuField<Type>(p, iF),
    procPatch_(refCast<const processorgpuFvPatch>(p))
{}


template<class Type>
Foam::processorFvsPatchgpuField<Type>::processorFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const gpuField<Type>& f
)
:
    coupledFvsPatchgpuField<Type>(p, iF, f),
    procPatch_(refCast<const processorgpuFvPatch>(p))
{}


template<class Type>
Foam::processorFvsPatchgpuField<Type>::processorFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const dictionary& dict
)
:
    coupledFvsPatchgpuField<Type>(p, iF, dict),
    procPatch_(refCast<const processorgpuFvPatch>(p, dict))
{
    if (!isType<processorgpuFvPatch>(p))
    {
        FatalIOErrorInFunction(dict)
            << "patch " << this->patch().index() << " not processor type. "
            << "Patch type = " << p.type()
            << exit(FatalIOError);
    }
}


template<class Type>
Foam::processorFvsPatchgpuField<Type>::processorFvsPatchgpuField
(
    const processorFvsPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    coupledFvsPatchgpuField<Type>(ptf, p, iF, mapper),
    procPatch_(refCast<const processorgpuFvPatch>(p))
{
    if (!isType<processorgpuFvPatch>(this->patch()))
    {
        FatalErrorInFunction
            << "Field type does not correspond to patch type for patch "
            << this->patch().index() << "." << endl
            << "Field type: " << typeName << endl
            << "Patch type: " << this->patch().type()
            << exit(FatalError);
    }
}


template<class Type>
Foam::processorFvsPatchgpuField<Type>::processorFvsPatchgpuField
(
    const processorFvsPatchgpuField<Type>& ptf
)
:
    coupledFvsPatchgpuField<Type>(ptf),
    procPatch_(refCast<const processorgpuFvPatch>(ptf.patch()))
{}


template<class Type>
Foam::processorFvsPatchgpuField<Type>::processorFvsPatchgpuField
(
    const processorFvsPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    coupledFvsPatchgpuField<Type>(ptf, iF),
    procPatch_(refCast<const processorgpuFvPatch>(ptf.patch()))
{}


// * * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * //

template<class Type>
Foam::processorFvsPatchgpuField<Type>::~processorFvsPatchgpuField()
{}


// ************************************************************************* //
