/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2018-2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::jumpCyclicFvPatchgpuField

Group
    grpCoupledBoundaryConditions

Description
    This boundary condition provides a base class for coupled-cyclic
    conditions with a specified 'jump' (or offset) between the values

See also
    Foam::cyclicFvPatchgpuField

SourceFiles
    jumpCyclicFvPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef jumpCyclicFvPatchgpuField_H
#define jumpCyclicFvPatchgpuField_H

#include "cyclicFvPatchgpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                   Class jumpCyclicFvPatchgpuField Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class jumpCyclicFvPatchgpuField
:
    public cyclicFvPatchgpuField<Type>
{

public:

    //- Runtime type information
    TypeName("jumpCyclic");


    // Constructors

        //- Construct from patch and internal field
        jumpCyclicFvPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        jumpCyclicFvPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&,
            const dictionary&,
            const bool valueRequired = true
        );

        //- Construct by mapping given jumpCyclicFvPatchgpuField onto a new patch
        jumpCyclicFvPatchgpuField
        (
            const jumpCyclicFvPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        jumpCyclicFvPatchgpuField
        (
            const jumpCyclicFvPatchgpuField<Type>&
        );

        //- Construct as copy setting internal field reference
        jumpCyclicFvPatchgpuField
        (
            const jumpCyclicFvPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpuvolMesh>&
        );


    // Member functions

        // Access

            //- Return the interface type
            virtual const word& interfaceFieldType() const
            {
                return cyclicFvPatchgpuField<Type>::type();
            }

            //- Return the "jump" across the patch as a "half" field
            virtual tmp<gpuField<Type>> jump() const  = 0;

        // Evaluation functions

            //- Return neighbour coupled given internal cell data
            tmp<gpuField<Type>> patchNeighbourField() const;

            //- Update result field based on interface functionality

            virtual void updateInterfaceMatrix
            (
                scalargpuField& result,
                const bool add,
                const gpulduAddressing& lduAddr,
                const label patchId,
                const scalargpuField& psiInternal,
                const scalargpuField& coeffs,
                const direction cmpt,
                const Pstream::commsTypes commsType
            ) const;

            //- Update result field based on interface functionality
            virtual void updateInterfaceMatrix
            (
                gpuField<Type>&,
                const bool add,
                const gpulduAddressing& lduAddr,
                const label patchId,
                const gpuField<Type>&,
                const scalargpuField&,
                const Pstream::commsTypes commsType
            ) const;
};

//- Update result field based on interface functionality

template<>
void jumpCyclicFvPatchgpuField<scalar>::updateInterfaceMatrix
(
    scalargpuField& result,
    const bool add,
    const gpulduAddressing& lduAddr,
    const label patchId,
    const scalargpuField& psiInternal,
    const scalargpuField& coeffs,
    const direction cmpt,
    const Pstream::commsTypes commsType
) const;


template<>
void jumpCyclicFvPatchgpuField<vector>::updateInterfaceMatrix
(
    scalargpuField& result,
    const bool add,
    const gpulduAddressing& lduAddr,
    const label patchId,
    const scalargpuField& psiInternal,
    const scalargpuField& coeffs,
    const direction cmpt,
    const Pstream::commsTypes commsType
) const;

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "jumpCyclicFvPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
