/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fv::gpudfsolverLaplacianScheme

Group
    grpFvLaplacianSchemes

Description
   

SourceFiles


\*---------------------------------------------------------------------------*/

#ifndef gpudfsolverLaplacianScheme_H
#define gpudfsolverLaplacianScheme_H

#include "gpulaplacianScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fv
{

/*---------------------------------------------------------------------------*\
                       Class gpudfsolverLaplacianScheme Declaration
\*---------------------------------------------------------------------------*/

template<class Type, class GType>
class gpudfsolverLaplacianScheme
:
    public fv::gpulaplacianScheme<Type, GType>
{
    // Private Member Functions

        tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> gammaSnGradCorr
        (
            const surfaceVectorgpuField& SfGammaCorr,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        //- No copy construct
        gpudfsolverLaplacianScheme(const gpudfsolverLaplacianScheme&) = delete;

        //- No copy assignment
        void operator=(const gpudfsolverLaplacianScheme&) = delete;


public:

    //- Runtime type information
    TypeName("dfsolver");


    // Constructors

        //- Construct null
        gpudfsolverLaplacianScheme(const gpufvMesh& mesh)
        :
            gpulaplacianScheme<Type, GType>(mesh)
        {}

        //- Construct from Istream
        gpudfsolverLaplacianScheme(const gpufvMesh& mesh, Istream& is)
        :
            gpulaplacianScheme<Type, GType>(mesh, is)
        {}

        //- Construct from mesh, interpolation and snGradScheme schemes
        gpudfsolverLaplacianScheme
        (
            const gpufvMesh& mesh,
            const tmp<gpusurfaceInterpolationScheme<GType>>& igs,
            const tmp<gpusnGradScheme<Type>>& sngs
        )
        :
            gpulaplacianScheme<Type, GType>(mesh, igs, sngs)
        {}


    //- Destructor
    virtual ~gpudfsolverLaplacianScheme() = default;


    // Member Functions

        static tmp<gpufvMatrix<Type>> fvmLaplacianUncorrected
        (
            const surfaceScalargpuField& gammaMagSf,
            const surfaceScalargpuField& deltaCoeffs,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> fvcLaplacian
        (
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        tmp<gpufvMatrix<Type>> fvmLaplacian
        (
            const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> fvcLaplacian
        (
            const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );
};


// Use macros to emulate partial-specialisation of the Laplacian functions
// for scalar diffusivity gamma

#define defineFvmgpuLaplacianScalarGamma(Type)                                    \
                                                                               \
template<>                                                                     \
tmp<gpufvMatrix<Type>> gpudfsolverLaplacianScheme<Type, scalar>::fvmLaplacian           \
(                                                                              \
    const GeometricgpuField<scalar, fvsPatchgpuField, gpusurfaceMesh>&,                 \
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&                         \
);                                                                             \
                                                                               \
template<>                                                                     \
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>                               \
gpudfsolverLaplacianScheme<Type, scalar>::fvcLaplacian                               \
(                                                                              \
    const GeometricgpuField<scalar, fvsPatchgpuField, gpusurfaceMesh>&,                 \
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&                         \
);


defineFvmgpuLaplacianScalarGamma(scalar);
defineFvmgpuLaplacianScalarGamma(vector);
defineFvmgpuLaplacianScalarGamma(sphericalTensor);
defineFvmgpuLaplacianScalarGamma(symmTensor);
defineFvmgpuLaplacianScalarGamma(tensor);


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fv

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpudfsolverLaplacianScheme.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
