/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvm

Description
    Calculate the matrix for implicit and explicit sources.

SourceFiles
    fvmSup.C

\*---------------------------------------------------------------------------*/

#ifndef gpufvmSup_H
#define gpufvmSup_H

#include "volgpuFieldsFwd.H"
#include "gpufvMatrix.H"
#include "zeroField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvm functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvm
{
   // Explicit source

        template<class Type>
        tmp<gpufvMatrix<Type>> Su
        (
            const DimensionedgpuField<Type, gpuvolMesh>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        tmp<gpufvMatrix<Type>> Su
        (
            const tmp<DimensionedgpuField<Type, gpuvolMesh>>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        tmp<gpufvMatrix<Type>> Su
        (
            const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        zeroField Su
        (
            const zero&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );


    // Implicit source

        template<class Type>
        tmp<gpufvMatrix<Type>> Sp
        (
            const volScalargpuField::Internal&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        tmp<gpufvMatrix<Type>> Sp
        (
            const tmp<volScalargpuField::Internal>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        tmp<gpufvMatrix<Type>> Sp
        (
            const tmp<volScalargpuField>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );


        template<class Type>
        tmp<gpufvMatrix<Type>> Sp
        (
            const dimensionedScalar&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );


        template<class Type>
        zeroField Sp
        (
            const zero&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );


    // Implicit/Explicit source depending on sign of coefficient

        template<class Type>
        tmp<gpufvMatrix<Type>> SuSp
        (
            const volScalargpuField::Internal&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        tmp<gpufvMatrix<Type>> SuSp
        (
            const tmp<volScalargpuField::Internal>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        tmp<gpufvMatrix<Type>> SuSp
        (
            const tmp<volScalargpuField>&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );

        template<class Type>
        zeroField SuSp
        (
            const zero&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpufvmSup.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
