/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "volgpuFields.H"
#include "surfacegpuFields.H"
#include "gpufvMatrix.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::Su
(
    const DimensionedgpuField<Type, gpuvolMesh>& su,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    const gpufvMesh& mesh = vf.mesh();

    tmp<gpufvMatrix<Type>> tfvm
    (
        new gpufvMatrix<Type>
        (
            vf,
            dimVol*su.dimensions()
        )
    );
    gpufvMatrix<Type>& fvm = tfvm.ref();

    fvm.source() -= mesh.V()*su;

    return tfvm;
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::Su
(
    const tmp<DimensionedgpuField<Type, gpuvolMesh>>& tsu,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<gpufvMatrix<Type>> tfvm = fvm::Su(tsu(), vf);
    tsu.clear();
    return tfvm;
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::Su
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tsu,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<gpufvMatrix<Type>> tfvm = fvm::Su(tsu(), vf);
    tsu.clear();
    return tfvm;
}


template<class Type>
Foam::zeroField
Foam::fvm::Su
(
    const zero&,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return zeroField();
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::Sp
(
    const volScalargpuField::Internal& sp,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    const gpufvMesh& mesh = vf.mesh();

    tmp<gpufvMatrix<Type>> tfvm
    (
        new gpufvMatrix<Type>
        (
            vf,
            dimVol*sp.dimensions()*vf.dimensions()
        )
    );
    gpufvMatrix<Type>& fvm = tfvm.ref();

    fvm.gpuDiag() += mesh.V()*sp;

    return tfvm;
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::Sp
(
    const tmp<volScalargpuField::Internal>& tsp,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<gpufvMatrix<Type>> tfvm = fvm::Sp(tsp(), vf);
    tsp.clear();
    return tfvm;
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::Sp
(
    const tmp<volScalargpuField>& tsp,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<gpufvMatrix<Type>> tfvm = fvm::Sp(tsp(), vf);
    tsp.clear();
    return tfvm;
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::Sp
(
    const dimensionedScalar& sp,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    const gpufvMesh& mesh = vf.mesh();

    tmp<gpufvMatrix<Type>> tfvm
    (
        new gpufvMatrix<Type>
        (
            vf,
            dimVol*sp.dimensions()*vf.dimensions()
        )
    );
    gpufvMatrix<Type>& fvm = tfvm.ref();

    fvm.gpuDiag() += mesh.V()*sp.value();

    return tfvm;
}


template<class Type>
Foam::zeroField
Foam::fvm::Sp
(
    const zero&,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
)
{
    return zeroField();
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::SuSp
(
    const volScalargpuField::Internal& susp,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    const gpufvMesh& mesh = vf.mesh();

    tmp<gpufvMatrix<Type>> tfvm
    (
        new gpufvMatrix<Type>
        (
            vf,
            dimVol*susp.dimensions()*vf.dimensions()
        )
    );
    gpufvMatrix<Type>& fvm = tfvm.ref();

    fvm.gpuDiag() += mesh.V()*max(susp.field(), scalar(0));

    fvm.source() -= mesh.V()*min(susp.field(), scalar(0))
        *vf.primitiveField();

    return tfvm;
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::SuSp
(
    const tmp<volScalargpuField::Internal>& tsusp,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<gpufvMatrix<Type>> tfvm = fvm::SuSp(tsusp(), vf);
    tsusp.clear();
    return tfvm;
}


template<class Type>
Foam::tmp<Foam::gpufvMatrix<Type>>
Foam::fvm::SuSp
(
    const tmp<volScalargpuField>& tsusp,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<gpufvMatrix<Type>> tfvm = fvm::SuSp(tsusp(), vf);
    tsusp.clear();
    return tfvm;
}


template<class Type>
Foam::zeroField
Foam::fvm::SuSp
(
    const zero&,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return zeroField();
}


// ************************************************************************* //
