/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvcVolumeIntegrate.H"
#include "gpufvMesh.H"
#include "gpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fvc
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
tmp<gpuField<Type>>
volumeIntegrate
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return vf.mesh().V()*vf.primitiveField();
}


template<class Type>
tmp<gpuField<Type>>
volumeIntegrate
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    tmp<gpuField<Type>> tvivf = tvf().mesh().V()*tvf().primitiveField();
    tvf.clear();
    return tvivf;
}


template<class Type>
tmp<gpuField<Type>> volumeIntegrate(const DimensionedgpuField<Type, gpuvolMesh>& df)
{
    return df.mesh().V()*df.field();
}


template<class Type>
tmp<gpuField<Type>>
volumeIntegrate(const tmp<DimensionedgpuField<Type, gpuvolMesh>>& tdf)
{
    tmp<gpuField<Type>> tdidf = tdf().mesh().V()*tdf().field();
    tdf.clear();
    return tdidf;
}


template<class Type>
dimensioned<Type>
domainIntegrate
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return dimensioned<Type>
    (
        "domainIntegrate(" + vf.name() + ')',
        dimVol*vf.dimensions(),
        gSum(fvc::volumeIntegrate(vf))
    );
}


template<class Type>
dimensioned<Type> domainIntegrate
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    dimensioned<Type> integral = domainIntegrate(tvf());
    tvf.clear();
    return integral;
}


template<class Type>
dimensioned<Type> domainIntegrate
(
    const DimensionedgpuField<Type, gpuvolMesh>& df
)
{
    return dimensioned<Type>
    (
        "domainIntegrate(" + df.name() + ')',
        dimVol*df.dimensions(),
        gSum(fvc::volumeIntegrate(df))
    );
}


template<class Type>
dimensioned<Type> domainIntegrate
(
    const tmp<DimensionedgpuField<Type, gpuvolMesh>>& tdf
)
{
    dimensioned<Type> integral = domainIntegrate(tdf());
    tdf.clear();
    return integral;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fvc

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
