/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvc

Description
    Surface integrate surfaceField creating a volField.
    Surface sum a surfaceField creating a volField.

SourceFiles
    fvcSurfaceIntegrate.C

\*---------------------------------------------------------------------------*/


#ifndef gpufvcSurfaceIntegrate_H
#define gpufvcSurfaceIntegrate_H

#include "primitiveFieldsFwd.H"
#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvc functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvc
{
    template<class Type>
    void surfaceIntegrate
    (
        gpuField<Type>&,
        const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
    surfaceIntegrate
    (
        const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
    surfaceIntegrate
    (
        const tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> surfaceSum
    (
        const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> surfaceSum
    (
        const tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>&
    );
}

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpufvcSurfaceIntegrate.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
