#ifndef JacobiSmoother_H
#define JacobiSmoother_H

#include "gpulduMatrix.H"

namespace Foam
{

class JacobiSmoother
:
    public gpulduMatrix::smoother
{
    scalar omega_;

public:

    TypeName("Jacobi");

    JacobiSmoother
    (
        const word& fieldName,
        const gpulduMatrix& matrix,
        const FieldField<gpuField, scalar>& interfaceBouCoeffs,
        const FieldField<gpuField, scalar>& interfaceIntCoeffs,
        const lduInterfacegpuFieldPtrsList& interfaces
    );

    //- Smooth the solution for a given number of sweeps
    virtual void smooth
    (
        scalargpuField& psi,
        const scalargpuField& source,
        const direction cmpt, 
        const label nSweeps
    ) const;

    //- Smooth the solution for a given number of sweeps
    virtual void scalarSmooth
    (
     	scalargpuField& psi,
       	const scalargpuField& Source,
        const direction cmpt,
        const label nSweeps
    ) const;
};

}

#endif

