/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "volgpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
inline Foam::tmp<Foam::volScalargpuField>
Foam::gpulimitFuncs::magSqr<Type>::operator()
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& phi
) const
{
    return Foam::magSqr(phi);
}


template<>
inline Foam::tmp<Foam::volScalargpuField>
Foam::gpulimitFuncs::magSqr<Foam::scalar>::operator()
(
    const volScalargpuField& phi
) const
{
    return phi;
}


template<>
inline Foam::tmp<Foam::volScalargpuField>
Foam::gpulimitFuncs::magSqr<Foam::symmTensor>::operator()
(
    const volSymmTensorgpuField& phi
) const
{
    return Foam::tr(phi);
}


template<>
inline Foam::tmp<Foam::volScalargpuField>
Foam::gpulimitFuncs::magSqr<Foam::tensor>::operator()
(
    const volTensorgpuField& phi
) const
{
    return Foam::tr(phi);
}


template<class Type>
inline Foam::tmp<Foam::volScalargpuField>
Foam::gpulimitFuncs::rhoMagSqr<Type>::operator()
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& phi
) const
{
    const volScalargpuField& rho =
        phi.db().objectRegistry::template lookupObject<volScalargpuField>("rho");
    return Foam::magSqr(phi/rho);
}


template<>
inline Foam::tmp<Foam::volScalargpuField>
Foam::gpulimitFuncs::rhoMagSqr<Foam::scalar>::operator()
(
    const volScalargpuField& phi
) const
{
    const volScalargpuField& rho =
        phi.db().objectRegistry::lookupObject<volScalargpuField>("rho");
    return phi/rho;
}


// ************************************************************************* //
