/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
    Copyright (C) 2016-2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvMesh.H"
#include "volgpuFields.H"
#include "surfacegpuFields.H"
#include "slicedVolgpuFields.H"
#include "slicedSurfacegpuFields.H"
#include "demandDrivenData.H"
#include "gpufvMeshLduAddressing.H"
//#include "fvMeshMapper.H"
#include "gpufvMatrix.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeNameAndDebug(gpufvMesh, 0);
}


// * * * * * * * * * * * * * Private Member Functions  * * * * * * * * * * * //

/*void Foam::fvMesh::clearGeomNotOldVol()
{
    meshObject::clearUpto
    <
        fvMesh,
        GeometricMeshObject,
        MoveableMeshObject
    >(*this);

    meshObject::clearUpto
    <
        lduMesh,
        GeometricMeshObject,
        MoveableMeshObject
    >(*this);

    slicedVolScalarField::Internal* VPtr =
        static_cast<slicedVolScalarField::Internal*>(VPtr_);
    deleteDemandDrivenData(VPtr);
    VPtr_ = nullptr;

    deleteDemandDrivenData(SfPtr_);
    deleteDemandDrivenData(magSfPtr_);
    deleteDemandDrivenData(CPtr_);
    deleteDemandDrivenData(CfPtr_);
}


void Foam::fvMesh::updateGeomNotOldVol()
{
    bool haveV = (VPtr_ != nullptr);
    bool haveSf = (SfPtr_ != nullptr);
    bool haveMagSf = (magSfPtr_ != nullptr);
    bool haveCP = (CPtr_ != nullptr);
    bool haveCf = (CfPtr_ != nullptr);

    clearGeomNotOldVol();

    // Now recreate the fields
    if (haveV)
    {
        (void)V();
    }
    if (haveSf)
    {
        (void)Sf();
    }
    if (haveMagSf)
    {
        (void)magSf();
    }
    if (haveCP)
    {
        (void)C();
    }
    if (haveCf)
    {
        (void)Cf();
    }
}


void Foam::fvMesh::clearGeom()
{
    clearGeomNotOldVol();

    deleteDemandDrivenData(V0Ptr_);
    deleteDemandDrivenData(V00Ptr_);

    // Mesh motion flux cannot be deleted here because the old-time flux
    // needs to be saved.
}


void Foam::fvMesh::clearAddressing(const bool isMeshUpdate)
{
    DebugInFunction << "isMeshUpdate: " << isMeshUpdate << endl;

    if (isMeshUpdate)
    {
        // Part of a mesh update. Keep meshObjects that have an updateMesh
        // callback
        meshObject::clearUpto
        <
            fvMesh,
            TopologicalMeshObject,
            UpdateableMeshObject
        >
        (
            *this
        );
        meshObject::clearUpto
        <
            lduMesh,
            TopologicalMeshObject,
            UpdateableMeshObject
        >
        (
            *this
        );
    }
    else
    {
        meshObject::clear<fvMesh, TopologicalMeshObject>(*this);
        meshObject::clear<lduMesh, TopologicalMeshObject>(*this);
    }
    deleteDemandDrivenData(lduPtr_);
}
*/

/*void Foam::gpufvMesh::storeOldVol(const scalargpuField& V)
{
    if (curTimeIndex_ < time().timeIndex())
    {
        DebugInFunction
            << " Storing old time volumes since from time " << curTimeIndex_
            << " and time now " << time().timeIndex()
            << " V:" << V.size() << endl;

        if (V00Ptr_ && V0Ptr_)
        {
            // Copy V0 into V00 storage
            *V00Ptr_ = *V0Ptr_;
        }

        if (V0Ptr_)
        {
            // Copy V into V0 storage
            V0Ptr_->scalargpuField::operator=(V);
        }
        else
        {
            // Allocate V0 storage, fill with V
            V0Ptr_ = new DimensionedgpuField<scalar, volMesh>
            (
                IOobject
                (
                    "V0",
                    time().timeName(),
                    *this,
                    IOobject::NO_READ,
                    IOobject::NO_WRITE,
                    false
                ),
                *this,
                dimVolume
            );
            scalargpuField& V0 = *V0Ptr_;
            // Note: V0 now sized with current mesh, not with (potentially
            //       different size) V.
            V0.setSize(V.size());
            V0 = V;
        }

        curTimeIndex_ = time().timeIndex();

        if (debug)
        {
            InfoInFunction
                << " Stored old time volumes V0:" << V0Ptr_->size()
                << endl;

            if (V00Ptr_)
            {
                InfoInFunction
                    << " Stored oldold time volumes V00:" << V00Ptr_->size()
                    << endl;
            }
        }
    }
}*/


/*void Foam::fvMesh::clearOutLocal()
{
    clearGeom();
    surfaceInterpolation::clearOut();

    clearAddressing();

    // Clear mesh motion flux
    deleteDemandDrivenData(phiPtr_);
}
*/

/*void Foam::gpufvMesh::UpdateToGpuGeom()
{
	clearGeom();

	VPtr_=new DimensionedgpuField<scalar,gpuvolMesh>(*this,hostmesh().V());
	V0Ptr_=new DimensionedgpuField<scalar,gpuvolMesh>(*this,hostmesh().V0());
	V00Ptr_=new DimensionedgpuField<scalar,gpuvolMesh>(*this,hostmesh().V00());
	SfPtr_=new surfaceVectorgpuField(*this,hostmesh().Sf());
	magSfPtr_=new surfaceScalargpuField(*this,hostmesh().magSf());
	CPtr_=new volVectorgpuField(*this,hostmesh().C());
	CfPtr_=new surfaceVectorgpuField(*this,hostmesh().Cf());
	phiPtr_=new surfaceScalargpuField(*this,hostmesh().phi());
}*/

void Foam::gpufvMesh::clearOut()
{
    hostmesh_.clearOut();
    deleteDemandDrivenData(lduPtr_);

	clearGeom();
}

void Foam::gpufvMesh::clearGeom()
{
    deleteDemandDrivenData(VPtr_);
    deleteDemandDrivenData(V0Ptr_);
    deleteDemandDrivenData(V00Ptr_);
    deleteDemandDrivenData(SfPtr_);
    deleteDemandDrivenData(magSfPtr_);
    deleteDemandDrivenData(CPtr_);
    deleteDemandDrivenData(CfPtr_);
    deleteDemandDrivenData(phiPtr_);
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::gpufvMesh::gpufvMesh(const fvMesh& baseMesh)
:
    gpusurfaceInterpolation(*this),
    hostmesh_(const_cast<fvMesh&>(baseMesh)),
	boundary_(*this, baseMesh.boundaryMesh()),
    lduPtr_(nullptr),
    curTimeIndex_(time().timeIndex()),
    VPtr_(nullptr),
    V0Ptr_(nullptr),
    V00Ptr_(nullptr),
    SfPtr_(nullptr),
    magSfPtr_(nullptr),
    CPtr_(nullptr),
    CfPtr_(nullptr),
    phiPtr_(nullptr)
{
    DebugInFunction << "Constructing gpufvMesh from fvMesh" << endl;
	
	if(fileHandler().isFile(time().timePath()/hostmesh().dbDir()/"V0")||
		fileHandler().isFile(time().timePath()/hostmesh().dbDir()/"meshPhi"))
		V0Ptr_=new DimensionedgpuField<scalar,gpuvolMesh>(hostmesh().V0(), *this, hostmesh().V0().dimensions(), hostmesh().V0());
	
	if(fileHandler().isFile(time().timePath()/hostmesh().dbDir()/"meshPhi"))
		phiPtr_=new surfaceScalargpuField(hostmesh().phi(), *this, hostmesh().phi().dimensions(), hostmesh().phi());

}



// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

Foam::gpufvMesh::~gpufvMesh()
{
    clearOut();
}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::SolverPerformance<Foam::scalar> Foam::gpufvMesh::solve
(
    gpufvMatrix<scalar>& m,
    const dictionary& dict
) const
{
    // Redirect to fvMatrix solver
    return m.solveSegregatedOrCoupled(dict);
}


Foam::SolverPerformance<Foam::vector> Foam::gpufvMesh::solve
(
    gpufvMatrix<vector>& m,
    const dictionary& dict
) const
{
    // Redirect to fvMatrix solver
    return m.solveSegregatedOrCoupled(dict);
}


Foam::SolverPerformance<Foam::sphericalTensor> Foam::gpufvMesh::solve
(
    gpufvMatrix<sphericalTensor>& m,
    const dictionary& dict
) const
{
    // Redirect to fvMatrix solver
    return m.solveSegregatedOrCoupled(dict);
}


Foam::SolverPerformance<Foam::symmTensor> Foam::gpufvMesh::solve
(
    gpufvMatrix<symmTensor>& m,
    const dictionary& dict
) const
{
    // Redirect to fvMatrix solver
    return m.solveSegregatedOrCoupled(dict);
}


Foam::SolverPerformance<Foam::tensor> Foam::gpufvMesh::solve
(
    gpufvMatrix<tensor>& m,
    const dictionary& dict
) const
{
    // Redirect to fvMatrix solver
    return m.solveSegregatedOrCoupled(dict);
}

void Foam::gpufvMesh::addFvPatches
(
    PtrList<polyPatch>& plist,
    const bool validBoundary
)
{
    if (boundary().size())
    {
        FatalErrorInFunction
            << " boundary already exists"
            << abort(FatalError);
    }

    hostmesh().addFvPatches(plist, validBoundary);
    boundary_.addPatches(hostmesh().boundaryMesh());
}


void Foam::gpufvMesh::addFvPatches
(
    const List<polyPatch*>& p,
    const bool validBoundary
)
{
    // Acquire ownership of the pointers
    PtrList<polyPatch> plist(const_cast<List<polyPatch*>&>(p));

    addFvPatches(plist, validBoundary);
}


void Foam::gpufvMesh::removeFvBoundary()
{
    DebugInFunction << "Removing boundary patches." << endl;

    // Remove fvBoundaryMesh data first.
    boundary_.clear();
    boundary_.setSize(0);
    hostmesh().removeFvBoundary();

    clearOut();
}



const Foam::gpufvBoundaryMesh& Foam::gpufvMesh::boundary() const
{
    return boundary_;
}


const Foam::gpulduAddressing& Foam::gpufvMesh::lduAddr() const
{
    if (!lduPtr_)
    {
        DebugInFunction
            << "Calculating fvMeshLduAddressing from nFaces:"
            << hostmesh().nFaces() << endl;

        lduPtr_ = new gpufvMeshLduAddressing(*this);

        return *lduPtr_;
    }

    return *lduPtr_;
}


Foam::gpulduInterfacePtrsList Foam::gpufvMesh::interfaces() const
{
    return boundary().interfaces();
}

void Foam::gpufvMesh::updateGeom()
{
    // Let surfaceInterpolation handle geometry calculation. Note: this does
    // lower levels updateGeom
    gpusurfaceInterpolation::updateGeom();
}

// * * * * * * * * * * * * * * * Member Operators  * * * * * * * * * * * * * //

bool Foam::gpufvMesh::operator!=(const gpufvMesh& rhs) const
{
    return &rhs != this;
}


bool Foam::gpufvMesh::operator==(const gpufvMesh& rhs) const
{
    return &rhs == this;
}


// ************************************************************************* //
