/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "faceAreaPairGGAMGAgglomeration.H"
#include "gpufvMesh.H"
#include "surfacegpuFields.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeNameAndDebug(faceAreaPairGGAMGAgglomeration, 0);

    addToRunTimeSelectionTable
    (
        GGAMGAgglomeration,
        faceAreaPairGGAMGAgglomeration,
        gpulduMesh
    );

    addToRunTimeSelectionTable
    (
        GGAMGAgglomeration,
        faceAreaPairGGAMGAgglomeration,
        geometry
    );
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::faceAreaPairGGAMGAgglomeration::faceAreaPairGGAMGAgglomeration
(
    const gpulduMesh& mesh,
    const dictionary& controlDict
)
:
    pairGGAMGAgglomeration(mesh, controlDict)
{
    const gpufvMesh& fvmesh = refCast<const gpufvMesh>(mesh);

    SubField<vector> sf(fvmesh.hostmesh().faceAreas(),fvmesh.magSf().primitiveField().size());

    //agglomerate(mesh, sqrt(fvmesh.magSf().primitiveField()));
    agglomerate
    (
        mesh,
        mag
        (
            cmptMultiply
            (
                static_cast<const Field<vector>&>(sf)
               /sqrt(mag(static_cast<const Field<vector>&>(sf))),
                vector(1, 1.01, 1.02)
                //vector::one
            )
        )
    );

}


Foam::faceAreaPairGGAMGAgglomeration::faceAreaPairGGAMGAgglomeration
(
    const gpulduMesh& mesh,
    const scalarField& cellVolumes,
    const vectorField& faceAreas,
    const dictionary& controlDict
)
:
    pairGGAMGAgglomeration(mesh, controlDict)
{
    //agglomerate(mesh, sqrt(mag(faceAreas)));
    agglomerate
    (
        mesh,
        mag
        (
            cmptMultiply
            (
                faceAreas
               /sqrt(mag(faceAreas)),
                vector(1, 1.01, 1.02)
                //vector::one
            )
        )
    );
}


// ************************************************************************* //
