/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InClass
    Foam::fvMatrix

Description
    A scalar instance of fvMatrix

SourceFiles
    fvScalarMatrix.C

\*---------------------------------------------------------------------------*/

#ifndef gpufvScalarMatrix_H
#define gpufvScalarMatrix_H

#include "gpufvMatrix.H"
#include "gpufvMatricesFwd.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

// Set reference level for a component of the solution
// on a given patch face
template<>
void gpufvMatrix<scalar>::setComponentReference
(
    const label patchi,
    const label facei,
    const direction,
    const scalar value
);

template<>
autoPtr<gpufvMatrix<scalar>::fvSolver> gpufvMatrix<scalar>::solver(const dictionary&);

template<>
solverPerformance gpufvMatrix<scalar>::fvSolver::solve(const dictionary&);

template<>
solverPerformance gpufvMatrix<scalar>::solveSegregated(const dictionary&);

template<>
tmp<scalargpuField> gpufvMatrix<scalar>::residual() const;

template<>
tmp<volScalargpuField> gpufvMatrix<scalar>::H() const;

template<>
tmp<volScalargpuField> gpufvMatrix<scalar>::H1() const;


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
