/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InClass
    Foam::surfaceFields

Description

SourceFiles
    surfaceFields.C

\*---------------------------------------------------------------------------*/

#ifndef surfacegpuFieldsFwd_H
#define surfacegpuFieldsFwd_H

#include "fieldTypes.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

// Forward Declarations
class gpusurfaceMesh;

template<class Type> class fvsPatchgpuField;

template<class Type, template<class> class PatchField, class GeoMesh>
class GeometricgpuField;

// Typedefs

typedef GeometricgpuField<scalar, fvsPatchgpuField, gpusurfaceMesh> surfaceScalargpuField;
typedef GeometricgpuField<vector, fvsPatchgpuField, gpusurfaceMesh> surfaceVectorgpuField;
typedef GeometricgpuField<sphericalTensor, fvsPatchgpuField, gpusurfaceMesh>
    surfaceSphericalTensorgpuField;
typedef GeometricgpuField<symmTensor, fvsPatchgpuField, gpusurfaceMesh>
    surfaceSymmTensorgpuField;
typedef GeometricgpuField<tensor, fvsPatchgpuField, gpusurfaceMesh> surfaceTensorgpuField;

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
