/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::processorFvsPatchgpuField

Description
    Foam::processorFvsPatchgpuField

SourceFiles
    processorFvsPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef processorFvsPatchgpuField_H
#define processorFvsPatchgpuField_H

#include "coupledFvsPatchgpuField.H"
#include "processorgpuFvPatch.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                      Class processorFvsPatch Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class processorFvsPatchgpuField
:
    public coupledFvsPatchgpuField<Type>
{
    // Private data

        //- Local reference cast into the processor patch
        const processorgpuFvPatch& procPatch_;


public:

    //- Runtime type information
    TypeName(processorgpuFvPatch::typeName_());


    // Constructors

        //- Construct from patch and internal field
        processorFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct from patch and internal field and patch field
        processorFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const gpuField<Type>&
        );

        //- Construct from patch, internal field and dictionary
        processorFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const dictionary&
        );

        //- Construct by mapping given processorFvsPatchgpuField onto a new patch
        processorFvsPatchgpuField
        (
            const processorFvsPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        processorFvsPatchgpuField(const processorFvsPatchgpuField<Type>&);

        //- Construct and return a clone
        virtual tmp<fvsPatchgpuField<Type>> clone() const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new processorFvsPatchgpuField<Type>(*this)
            );
        }

        //- Construct as copy setting internal field reference
        processorFvsPatchgpuField
        (
            const processorFvsPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvsPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpusurfaceMesh>& iF
        ) const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new processorFvsPatchgpuField<Type>(*this, iF)
            );
        }


    //- Destructor
    virtual ~processorFvsPatchgpuField();


    // Member functions

        // Access

            //- Return true if running parallel
            virtual bool coupled() const
            {
                if (Pstream::parRun())
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "processorFvsPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
