/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::noSlipFvPatchVectorField

Group
    grpWallBoundaryConditions

Description
    This boundary condition fixes the velocity to zero at walls.

Usage
    Example of the boundary condition specification:
    \verbatim
    <patchName>
    {
        type            noSlip;
    }
    \endverbatim

See also
    Foam::fixedValueFvPatchVectorField

SourceFiles
    noSlipFvPatchVectorField.C

\*---------------------------------------------------------------------------*/

#ifndef noSlipFvPatchVectorgpuField_H
#define noSlipFvPatchVectorgpuField_H

#include "fixedValueFvPatchgpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
             Class noSlipFvPatchVectorField Declaration
\*---------------------------------------------------------------------------*/

class noSlipFvPatchVectorgpuField
:
    public fixedValueFvPatchVectorgpuField
{

public:

    //- Runtime type information
    TypeName("noSlip");


    // Constructors

        //- Construct from patch and internal field
        noSlipFvPatchVectorgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<vector, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        noSlipFvPatchVectorgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<vector, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given noSlipFvPatchVectorField
        //  onto a new patch
        noSlipFvPatchVectorgpuField
        (
            const noSlipFvPatchVectorgpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<vector, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        noSlipFvPatchVectorgpuField
        (
            const noSlipFvPatchVectorgpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchVectorgpuField> clone() const
        {
            return tmp<fvPatchVectorgpuField>
            (
                new noSlipFvPatchVectorgpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        noSlipFvPatchVectorgpuField
        (
            const noSlipFvPatchVectorgpuField&,
            const DimensionedgpuField<vector, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchVectorgpuField> clone
        (
            const DimensionedgpuField<vector, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchVectorgpuField>
            (
                new noSlipFvPatchVectorgpuField(*this, iF)
            );
        }


    // Member functions

        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
