/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "zeroGradientFvPatchgpuField.H"
#include "fvPatchgpuFieldMapper.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::zeroGradientFvPatchgpuField<Type>::zeroGradientFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    fvPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::zeroGradientFvPatchgpuField<Type>::zeroGradientFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fvPatchgpuField<Type>(p, iF, dict, false)
{
    fvPatchgpuField<Type>::operator=(this->patchInternalField());
}


template<class Type>
Foam::zeroGradientFvPatchgpuField<Type>::zeroGradientFvPatchgpuField
(
    const zeroGradientFvPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::zeroGradientFvPatchgpuField<Type>::zeroGradientFvPatchgpuField
(
    const zeroGradientFvPatchgpuField& zgpf
)
:
    fvPatchgpuField<Type>(zgpf)
{}


template<class Type>
Foam::zeroGradientFvPatchgpuField<Type>::zeroGradientFvPatchgpuField
(
    const zeroGradientFvPatchgpuField& zgpf,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    fvPatchgpuField<Type>(zgpf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
void Foam::zeroGradientFvPatchgpuField<Type>::evaluate(const Pstream::commsTypes)
{
    if (!this->updated())
    {
        this->updateCoeffs();
    }

    fvPatchgpuField<Type>::operator==(this->patchInternalField());
    fvPatchgpuField<Type>::evaluate();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::zeroGradientFvPatchgpuField<Type>::valueInternalCoeffs
(
    const tmp<scalargpuField>&
) const
{
    return tmp<gpuField<Type>>
    (
        new gpuField<Type>(this->size(), pTraits<Type>::one)
    );
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::zeroGradientFvPatchgpuField<Type>::valueBoundaryCoeffs
(
    const tmp<scalargpuField>&
) const
{
    return tmp<gpuField<Type>>
    (
        new gpuField<Type>(this->size(), Zero)
    );
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::zeroGradientFvPatchgpuField<Type>::gradientInternalCoeffs() const
{
    return tmp<gpuField<Type>>
    (
        new gpuField<Type>(this->size(), Zero)
    );
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::zeroGradientFvPatchgpuField<Type>::gradientBoundaryCoeffs() const
{
    return tmp<gpuField<Type>>
    (
        new gpuField<Type>(this->size(), Zero)
    );
}


// ************************************************************************* //
