/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvmDiv.H"
#include "gpufvMesh.H"
#include "gpufvMatrix.H"
#include "gpuconvectionScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fvm
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
tmp<gpufvMatrix<Type>>
div
(
    const surfaceScalargpuField& flux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    return fv::gpuconvectionScheme<Type>::New
    (
        vf.mesh(),
        flux,
        vf.mesh().hostmesh().divScheme(name)
    )().fvmDiv(flux, vf);
}

template<class Type>
tmp<gpufvMatrix<Type>>
div
(
    const tmp<surfaceScalargpuField>& tflux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    tmp<gpufvMatrix<Type>> Div(fvm::div(tflux(), vf, name));
    tflux.clear();
    return Div;
}


template<class Type>
tmp<gpufvMatrix<Type>>
div
(
    const surfaceScalargpuField& flux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvm::div(flux, vf, "div("+flux.name()+','+vf.name()+')');
}

template<class Type>
tmp<gpufvMatrix<Type>>
div
(
    const tmp<surfaceScalargpuField>& tflux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<gpufvMatrix<Type>> Div(fvm::div(tflux(), vf));
    tflux.clear();
    return Div;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fvm

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
