/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvc

Description
    Calculate the mesh motion flux and convert fluxes from absolute to relative
    and back.

SourceFiles
    fvcMeshPhi.C

\*---------------------------------------------------------------------------*/

#ifndef gpufvcMeshPhi_H
#define gpufvcMeshPhi_H

#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"
#include "dimensionedTypes.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvc functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvc
{
    tmp<surfaceScalargpuField> meshPhi
    (
        const volVectorgpuField& U
    );

    tmp<surfaceScalargpuField> meshPhi
    (
        const dimensionedScalar& rho,
        const volVectorgpuField& U
    );

    tmp<surfaceScalargpuField> meshPhi
    (
        const volScalargpuField& rho,
        const volVectorgpuField& U
    );


    //- Make the given flux relative
    void makeRelative
    (
        surfaceScalargpuField& phi,
        const volVectorgpuField& U
    );

    //- Make the given flux relative
    void makeRelative
    (
        surfaceScalargpuField& phi,
        const dimensionedScalar& rho,
        const volVectorgpuField& U
    );

    //- Make the given flux relative
    void makeRelative
    (
        surfaceScalargpuField& phi,
        const volScalargpuField& rho,
        const volVectorgpuField& U
    );


    //- Make the given flux absolute
    void makeAbsolute
    (
        surfaceScalargpuField& phi,
        const volVectorgpuField& U
    );

    //- Make the given flux absolute
    void makeAbsolute
    (
        surfaceScalargpuField& phi,
        const dimensionedScalar& rho,
        const volVectorgpuField& U
    );

    //- Make the given flux absolute
    void makeAbsolute
    (
        surfaceScalargpuField& phi,
        const volScalargpuField& rho,
        const volVectorgpuField& U
    );


    //- Return the given absolute flux in relative form
    tmp<surfaceScalargpuField> relative
    (
        const tmp<surfaceScalargpuField>& tphi,
        const volVectorgpuField& U
    );

    //- Return the given absolute flux in relative form
    tmp<surfaceScalargpuField> relative
    (
        const tmp<surfaceScalargpuField>& tphi,
        const volScalargpuField& rho,
        const volVectorgpuField& U
    );


    //- Return the given relative flux in absolute form
    tmp<surfaceScalargpuField> absolute
    (
        const tmp<surfaceScalargpuField>& tphi,
        const volVectorgpuField& U
    );

    //- Return the given relative flux in absolute form
    tmp<surfaceScalargpuField> absolute
    (
        const tmp<surfaceScalargpuField>& tphi,
        const volScalargpuField& rho,
        const volVectorgpuField& U
    );

    void correctUf
    (
        autoPtr<surfaceVectorgpuField>& Uf,
        const volVectorgpuField& U,
        const surfaceScalargpuField& phi
    );

    void correctRhoUf
    (
        autoPtr<surfaceVectorgpuField>& rhoUf,
        const volScalargpuField& rho,
        const volVectorgpuField& U,
        const surfaceScalargpuField& phi
    );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
