/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvc

Description
    Calculate the laplacian of the given field.

SourceFiles
    fvcLaplacian.C

\*---------------------------------------------------------------------------*/


#ifndef gpufvcLaplacian_H
#define gpufvcLaplacian_H

#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"
#include "dimensionedTypes.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvc functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvc
{
    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
        const word&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&
    );


    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const dimensioned<GType>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const dimensioned<GType>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const dimensioned<GType>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const dimensioned<GType>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&
    );


    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&
    );


    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
        const word&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&
    );

    template<class Type, class GType>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>&,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&
    );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpufvcLaplacian.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
