/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::constrainPressure

Description

SourceFiles
    constrainPressure.C

\*---------------------------------------------------------------------------*/

#ifndef gpuconstrainPressure_H
#define gpuconstrainPressure_H

#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"
//#include "IOMRFZoneList.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

/*---------------------------------------------------------------------------*\
                           Class NullMRF Declaration
\*---------------------------------------------------------------------------*/

class gpuNullMRF
{
public:

    // Constructors

        //- Construct null
        gpuNullMRF()
        {}


    // Member Functions

        //- Return the argument unchanged
        template<class Type>
        inline const Type& relative(const Type& U) const
        {
            return U;
        }

        //- Return the argument unchanged
        template<class Type>
        inline const Type& relative(const Type& U, const label patchi) const
        {
            return U;
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class RhoType, class RAUType, class MRFType>
void constrainPressure
(
    volScalargpuField& p,
    const RhoType& rho,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rhorAU,
    const MRFType& MRF
);

template<class RAUType>
void constrainPressure
(
    volScalargpuField& p,
    const volScalargpuField& rho,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rhorAU
);

template<class RAUType, class MRFType>
void constrainPressure
(
    volScalargpuField& p,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rAU,
    const MRFType& MRF
);

template<class RAUType>
void constrainPressure
(
    volScalargpuField& p,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rAU
);


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpuconstrainPressure.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
