/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2016 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "algebraicPairGGAMGAgglomeration.H"
#include "gpulduMatrix.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeNameAndDebug(algebraicPairGGAMGAgglomeration, 0);

    addToRunTimeSelectionTable
    (
        GGAMGAgglomeration,
        algebraicPairGGAMGAgglomeration,
        gpulduMatrix
    );
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::algebraicPairGGAMGAgglomeration::algebraicPairGGAMGAgglomeration
(
    const gpulduMatrix& matrix,
    const dictionary& controlDict
)
:
    pairGGAMGAgglomeration(matrix.mesh(), controlDict)
{
    const gpulduMesh& mesh = matrix.mesh();

    if (matrix.hasLower())
    {
        scalarField upper(matrix.gpuUpper().size());
        scalarField lower(matrix.gpuLower().size());
        thrust::copy(matrix.gpuUpper().begin(),matrix.gpuUpper().end(),upper.begin());
        thrust::copy(matrix.gpuLower().begin(),matrix.gpuLower().end(),lower.begin());
        agglomerate(mesh, max(mag(upper), mag(lower)));
    }
    else
    {
        scalarField upper(matrix.gpuUpper().size());
        thrust::copy(matrix.gpuUpper().begin(),matrix.gpuUpper().end(),upper.begin());
        agglomerate(mesh, mag(upper));
    }
}


// ************************************************************************* //
