/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2013 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::cyclicACMILduInterfaceField

Description
    Abstract base class for cyclic ACMI coupled interfaces

SourceFiles
    cyclicACMILduInterfaceField.C

\*---------------------------------------------------------------------------*/

#ifndef cyclicACMILduInterfacegpuField_H
#define cyclicACMILduInterfacegpuField_H

#include "cyclicAMILduInterfacegpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                 Class cyclicACMILduInterfaceField Declaration
\*---------------------------------------------------------------------------*/

class cyclicACMILduInterfacegpuField
:
    public cyclicAMILduInterfacegpuField
{

public:

    //- Runtime type information
    TypeName("cyclicACMILduInterfacegpuField");


    // Constructors

        //- Construct null
        cyclicACMILduInterfacegpuField()
        {}


    //- Destructor
    virtual ~cyclicACMILduInterfacegpuField();


    // Member Functions

        //- Transform given patch field

        template<class Type>
        void transformCoupleField(gpuField<Type>& f) const;

        //- Transform given patch internal field

        void transformCoupleField
        (   
            scalargpuField& psiInternal,
            const direction cmpt
        ) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "tensorField.H"

template<class Type>
void Foam::cyclicACMILduInterfacegpuField::transformCoupleField
(
    gpuField<Type>& f
) const
{
    cyclicAMILduInterfacegpuField::transformCoupleField(f);
}

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
