/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2016-2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpulduPrimitiveProcessorInterface.H"
#include "transformField.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeName(gpulduPrimitiveProcessorInterface);
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::gpulduPrimitiveProcessorInterface::gpulduPrimitiveProcessorInterface
(
    const labelgpuList& faceCells,
    const label myProcNo,
    const label neighbProcNo,
    const tensorgpuField& gforwardT,
    const int tag,
    const label comm
)
:
    faceCells_(faceCells),
    myProcNo_(myProcNo),
    neighbProcNo_(neighbProcNo),
    gForwardT_(gforwardT),
    tag_(tag),
    comm_(comm)
{}


// * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * * //

Foam::tmp<Foam::labelgpuField>
Foam::gpulduPrimitiveProcessorInterface::interfaceInternalField
(
    const labelgpuList& internalData
) const
{
    return interfaceInternalField(internalData, faceCells_);
}


Foam::tmp<Foam::labelgpuField>
Foam::gpulduPrimitiveProcessorInterface::interfaceInternalField
(
    const labelgpuList& internalData,
    const labelgpuList& faceCells
) const
{
    auto tfld = tmp<labelgpuField>::New(faceCells.size());
    auto& fld = tfld.ref();

    thrust::copy(thrust::make_permutation_iterator(internalData.begin(),faceCells.begin()),
                 thrust::make_permutation_iterator(internalData.begin(),faceCells.end()),
                 fld.begin());
    return tfld;
}


void Foam::gpulduPrimitiveProcessorInterface::initInternalFieldTransfer
(
    const Pstream::commsTypes commsType,
    const labelgpuList& iF
) const
{
    processorgpuLduInterface::send(commsType, interfaceInternalField(iF)());
}


void Foam::gpulduPrimitiveProcessorInterface::initInternalFieldTransfer
(
    const Pstream::commsTypes commsType,
    const labelgpuList& iF,
    const labelgpuList& faceCells
) const
{
    processorgpuLduInterface::send
    (
        commsType,
        interfaceInternalField(iF, faceCells)()
    );
}


Foam::tmp<Foam::labelgpuField>
Foam::gpulduPrimitiveProcessorInterface::internalFieldTransfer
(
    const Pstream::commsTypes commsType,
    const labelgpuList&
) const
{
    return processorgpuLduInterface::receive<label>(commsType, faceCells_.size());
}

// ************************************************************************* //
