/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2018 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "scalar.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class arg2>
class innerProduct<one, arg2>
{
public:

    typedef arg2 type;
};

__host__ __device__
inline scalar operator+(const scalar& t, const one&) noexcept
{
    return t + 1;
}


__host__ __device__
inline scalar operator+(const one&, const scalar& t) noexcept
{
    return 1 + t;
}

__host__ __device__
inline scalar operator-(const scalar& t, const one&) noexcept
{
    return t - 1;
}


__host__ __device__
inline scalar operator-(const one&, const scalar& t) noexcept
{
    return 1 - t;
}


__host__ __device__
inline constexpr const one& operator*(const one& o, const one&) noexcept
{
    return o;
}



template<class Type>
__host__ __device__
inline constexpr const Type& operator*(const Type& val, const one&) noexcept
{
    return val;
}


template<class Type>
__host__ __device__
inline constexpr const Type& operator*(const one&, const Type& val) noexcept
{
    return val;
}

template<class Type>
__host__ __device__
inline constexpr const Type& operator&(const one&, const Type& val) noexcept
{
    return val;
}

__host__ __device__
inline constexpr const one& operator/(const one& o, const one&) noexcept
{
    return o;
}

template<class Type>
__host__ __device__
inline Type operator/(const one&, const Type& val)
{
    return scalar(1)/val;
}


template<class Type>
__host__ __device__
inline constexpr const Type& operator/(const Type& val, const one&) noexcept
{
    return val;
}

__host__ __device__
inline constexpr const one& min(const one& o, const one&) noexcept
{
    return o;
}


template<class Type>
__host__ __device__
inline Type min(const one&, const Type& t) noexcept
{
    return min(scalar(1), t);
}


template<class Type>
__host__ __device__
inline Type min(const Type& t, const one&) noexcept
{
    return min(t, scalar(1));
}

__host__ __device__
inline constexpr const one& max(const one& o, const one&) noexcept
{
    return o;
}


template<class Type>
__host__ __device__
inline Type max(const one&, const Type& t) noexcept
{
    return max(scalar(1), t);
}

template<class Type>
__host__ __device__
inline Type max(const Type& t, const one&) noexcept
{
    return max(t, scalar(1));
}

inline thrust::constant_iterator<scalar, thrust::use_default, thrust::use_default> one::begin() const
{
     return thrust::make_constant_iterator(scalar(1));
}

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
