#include "DeviceConfig.H"

namespace Foam {

    int deviceCount()
    {
        int num_devices;
        HIP_CALL(hipGetDeviceCount(&num_devices));
        return num_devices;
    }

    int currentDevice()
    {
        int device;
        HIP_CALL(hipGetDevice(&device));
        return device;
    }

    void setCurrentDevice(int device)
    {
        HIP_CALL(hipSetDevice(device));
    }

    int deviceComputeCapability(int device)
    {
        hipDeviceProp_t deviceProp;
        HIP_CALL(hipGetDeviceProperties(&deviceProp, device));
        return 10*deviceProp.major + deviceProp.minor;
    }

    int currentComputeCapability()
    {
        return deviceComputeCapability(currentDevice());
    }

    bool needTextureBind()
    {
        static bool needBind = currentComputeCapability() < 35;
        return needBind;
    }

}
