/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | cfMesh: A library for mesh generation
   \\    /   O peration     |
    \\  /    A nd           | www.cfmesh.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2014-2017 Creative Fields, Ltd.
-------------------------------------------------------------------------------
Author
     Franjo Juretic (franjo.juretic@c-fields.com)

License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::Module::meshOctreeSlot

Description
    A class holding information about octree data generated by a single
    thread

\*---------------------------------------------------------------------------*/

#ifndef meshOctreeSlot_H
#define meshOctreeSlot_H

#include "VRWGraph.H"
#include "FRWGraph.H"
#include "meshOctreeCube.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace Module
{

/*---------------------------------------------------------------------------*\
                       Class meshOctreeSlot Declaration
\*---------------------------------------------------------------------------*/

class meshOctreeSlot
{
public:

    // Public data

        //- List of octree cubes
        LongList<meshOctreeCube> cubes_;

        //- Pointers to child cubes
        FRWGraph<meshOctreeCube*, 8> childCubes_;

        //- surface triangles contained in an octree cube
        VRWGraph containedTriangles_;

        //- feature edges contained in an octree cube
        VRWGraph containedEdges_;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Module
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
