/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::timeVaryingAlphaContactAngleFvPatchScalarField

Description
    A time-varying alphaContactAngle scalar boundary condition
    (alphaContactAngleTwoPhaseFvPatchScalarField)

SourceFiles
    timeVaryingAlphaContactAngleFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef timeVaryingAlphaContactAngleFvPatchScalargpuField_H
#define timeVaryingAlphaContactAngleFvPatchScalargpuField_H

#include "alphaContactAngleTwoPhaseFvPatchScalargpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
            Class timeVaryingAlphaContactAngleFvPatch Declaration
\*---------------------------------------------------------------------------*/

class timeVaryingAlphaContactAngleFvPatchScalargpuField
:
    public alphaContactAngleTwoPhaseFvPatchScalargpuField
{
    // Private data

        // Equilibrium contact angle control parameters
        scalar t0_;
        scalar thetaT0_;
        scalar te_;
        scalar thetaTe_;


public:

    //- Runtime type information
    TypeName("timeVaryingAlphaContactAngle");


    // Constructors

        //- Construct from patch and internal field
        timeVaryingAlphaContactAngleFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        timeVaryingAlphaContactAngleFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given
        //  timeVaryingAlphaContactAngleFvPatchScalarField onto a new patch
        timeVaryingAlphaContactAngleFvPatchScalargpuField
        (
            const timeVaryingAlphaContactAngleFvPatchScalargpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchScalargpuField> clone() const
        {
            return tmp<fvPatchScalargpuField>
            (
                new timeVaryingAlphaContactAngleFvPatchScalargpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        timeVaryingAlphaContactAngleFvPatchScalargpuField
        (
            const timeVaryingAlphaContactAngleFvPatchScalargpuField&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchScalargpuField> clone
        (
            const DimensionedgpuField<scalar, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchScalargpuField>
            (
                new timeVaryingAlphaContactAngleFvPatchScalargpuField(*this, iF)
            );
        }


    // Member Functions

        //- Evaluate and return the time-varying equilibrium contact-angle
        virtual tmp<scalargpuField> theta
        (
            const fvPatchVectorgpuField& Up,
            const fvsPatchVectorgpuField& nHat
        ) const;

        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
