/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2015-2017 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::temperatureDependentAlphaContactAngleFvPatchScalarField

Description
    Temperature-dependent alphaContactAngle scalar boundary condition.

    The contact angle is evaluated from the specified Foam::Function1 for the
    temperature field looked-up from the mesh database the name of which
    may optionally be provided.

Usage
    \table
        Property     | Description             | Required    | Default value
        T            | Temperature field name  | no          | T
        theta0       | Contact angle function  | yes         |
    \endtable

    Example of the boundary condition specification:
    \verbatim
    <patchName>
    {
        type            temperatureDependentAlphaContactAngle;
        theta0          constant 60;
    }
    \endverbatim

See also
    Foam::alphaContactAngleTwoPhaseFvPatchScalarField
    Foam::constantAlphaContactAngleFvPatchScalarField
    Foam::Function1

SourceFiles
    temperatureDependentAlphaContactAngleFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef temperatureDependentAlphaContactAngleFvPatchScalargpuField_H
#define temperatureDependentAlphaContactAngleFvPatchScalargpuField_H

#include "alphaContactAngleTwoPhaseFvPatchScalargpuField.H"
#include "Function1.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
       Class temperatureDependentAlphaContactAngleFvPatch Declaration
\*---------------------------------------------------------------------------*/

class temperatureDependentAlphaContactAngleFvPatchScalargpuField
:
    public alphaContactAngleTwoPhaseFvPatchScalargpuField
{
    // Private data

        //- Name of temperature field, default = "T"
        word TName_;

        //- Equilibrium contact angle function
        autoPtr<Function1<scalar>> theta0_;


public:

    //- Runtime type information
    TypeName("temperatureDependentAlphaContactAngle");


    // Constructors

        //- Construct from patch and internal field
        temperatureDependentAlphaContactAngleFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        temperatureDependentAlphaContactAngleFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given
        //  temperatureDependentAlphaContactAngleFvPatchScalarField
        //  onto a new patch
        temperatureDependentAlphaContactAngleFvPatchScalargpuField
        (
            const temperatureDependentAlphaContactAngleFvPatchScalargpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        temperatureDependentAlphaContactAngleFvPatchScalargpuField
        (
            const temperatureDependentAlphaContactAngleFvPatchScalargpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchScalargpuField> clone() const
        {
            return tmp<fvPatchScalargpuField>
            (
                new temperatureDependentAlphaContactAngleFvPatchScalargpuField
                (
                    *this
                )
            );
        }

        //- Construct as copy setting internal field reference
        temperatureDependentAlphaContactAngleFvPatchScalargpuField
        (
            const temperatureDependentAlphaContactAngleFvPatchScalargpuField&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchScalargpuField> clone
        (
            const DimensionedgpuField<scalar, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchScalargpuField>
            (
                new temperatureDependentAlphaContactAngleFvPatchScalargpuField
                (
                    *this,
                    iF
                )
            );
        }


    // Member functions

        //- Return the equilibrium contact-angle
        virtual tmp<scalargpuField> theta
        (
            const fvPatchVectorgpuField& Up,
            const fvsPatchVectorgpuField& nHat
        ) const;

        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
