/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "alphaContactAngleTwoPhaseFvPatchScalargpuField.H"
#include "fvPatchFieldMapper.H"
#include "gpuvolMesh.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

const Foam::Enum
<
    Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::limitControls
>
Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::limitControlNames_
({
    { limitControls::lcNone, "none" },
    { limitControls::lcGradient, "gradient" },
    { limitControls::lcZeroGradient, "zeroGradient" },
    { limitControls::lcAlpha, "alpha" },
});


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::
alphaContactAngleTwoPhaseFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedGradientFvPatchScalargpuField(p, iF),
    limit_(lcZeroGradient)
{}


Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::
alphaContactAngleTwoPhaseFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedGradientFvPatchScalargpuField(p, iF),
    limit_(limitControlNames_.get("limit", dict))
{
    if (dict.found("gradient"))
    {
        gradient() = scalargpuField("gradient", dict, p.size());
        fixedGradientFvPatchScalargpuField::updateCoeffs();
        fixedGradientFvPatchScalargpuField::evaluate();
    }
    else
    {
        fvPatchgpuField<scalar>::operator=(patchInternalField());
        gradient() = 0.0;
    }
}


Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::
alphaContactAngleTwoPhaseFvPatchScalargpuField
(
    const alphaContactAngleTwoPhaseFvPatchScalargpuField& acpsf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedGradientFvPatchScalargpuField(acpsf, p, iF, mapper),
    limit_(acpsf.limit_)
{}


Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::
alphaContactAngleTwoPhaseFvPatchScalargpuField
(
    const alphaContactAngleTwoPhaseFvPatchScalargpuField& acpsf
)
:
    fixedGradientFvPatchScalargpuField(acpsf),
    limit_(acpsf.limit_)
{}


Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::
alphaContactAngleTwoPhaseFvPatchScalargpuField
(
    const alphaContactAngleTwoPhaseFvPatchScalargpuField& acpsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedGradientFvPatchScalargpuField(acpsf, iF),
    limit_(acpsf.limit_)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::evaluate
(
    const Pstream::commsTypes
)
{
    if (limit_ == lcGradient)
    {
        gradient() =
        patch().deltaCoeffs()
       *(
           max(min
           (
               *this + gradient()/patch().deltaCoeffs(),
               scalar(1)), scalar(0)
           ) - *this
       );
    }
    else if (limit_ == lcZeroGradient)
    {
        gradient() = 0.0;
    }

    fixedGradientFvPatchScalargpuField::evaluate();

    if (limit_ == lcAlpha)
    {
        scalargpuField::operator=(max(min(*this, scalar(1)), scalar(0)));
    }
}


void Foam::alphaContactAngleTwoPhaseFvPatchScalargpuField::write
(
    Ostream& os
) const
{
    fixedGradientFvPatchScalargpuField::write(os);
    os.writeEntry("limit", limitControlNames_[limit_]);
}


// ************************************************************************* //
