/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2012 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gradientEnergyFvPatchScalargpuField.H"
#include "addToRunTimeSelectionTable.H"
#include "fvPatchgpuFieldMapper.H"
#include "volgpuFields.H"
#include "basicThermo.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::gradientEnergyFvPatchScalargpuField::
gradientEnergyFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedGradientFvPatchScalargpuField(p, iF)
{}


Foam::gradientEnergyFvPatchScalargpuField::
gradientEnergyFvPatchScalargpuField
(
    const gradientEnergyFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedGradientFvPatchScalargpuField(ptf, p, iF, mapper)
{}


Foam::gradientEnergyFvPatchScalargpuField::
gradientEnergyFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedGradientFvPatchScalargpuField(p, iF, dict)
{}


Foam::gradientEnergyFvPatchScalargpuField::
gradientEnergyFvPatchScalargpuField
(
    const gradientEnergyFvPatchScalargpuField& tppsf
)
:
    fixedGradientFvPatchScalargpuField(tppsf)
{}


Foam::gradientEnergyFvPatchScalargpuField::
gradientEnergyFvPatchScalargpuField
(
    const gradientEnergyFvPatchScalargpuField& tppsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedGradientFvPatchScalargpuField(tppsf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::gradientEnergyFvPatchScalargpuField::updateCoeffs()
{
    if (updated())
    {
        return;
    }

    const basicThermo& thermo = basicThermo::lookupThermo(*this);
    const label patchi = patch().index();

    const scalargpuField& pw = thermo.p().boundaryField()[patchi];
    fvPatchScalargpuField& Tw =
        const_cast<fvPatchScalargpuField&>(thermo.T().boundaryField()[patchi]);

    Tw.evaluate();

    gradient() = thermo.Cpv(pw, Tw, patchi)*Tw.snGrad()
      + patch().deltaCoeffs()*
        (
            thermo.he(pw, Tw, patchi)
          - thermo.he(pw, Tw, patch().gpuFaceCells())
        );

    fixedGradientFvPatchScalargpuField::updateCoeffs();
}


void Foam::gradientEnergyFvPatchScalargpuField::write(Ostream& os) const
{
    fixedGradientFvPatchScalargpuField::write(os);
    this->writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchScalargpuField,
        gradientEnergyFvPatchScalargpuField
    );
}

// ************************************************************************* //
