/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2012-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::energyJumpAMIFvPatchScalarField

Group
    grpThermoBoundaryConditions grpCoupledBoundaryConditions

Description
    This boundary condition provides an energy jump condition across a pair
    of coupled patches with an arbitrary mesh interface (AMI).  It is not
    applied directly, but is employed on-the-fly when converting temperature
    boundary conditions into energy.

See also
    Foam::fixedJumpAMIFvPatchField

SourceFiles
    energyJumpAMIFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef energyJumpAMIFvPatchScalargpuField_H
#define energyJumpAMIFvPatchScalargpuField_H

#include "fixedJumpAMIFvPatchgpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
              Class energyJumpAMIFvPatchScalarField Declaration
\*---------------------------------------------------------------------------*/

class energyJumpAMIFvPatchScalargpuField
:
    public fixedJumpAMIFvPatchgpuField<scalar>
{

public:

    //- Runtime type information
    TypeName("energyJumpAMI");

    // Constructors

        //- Construct from patch and internal field
        energyJumpAMIFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        energyJumpAMIFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given energyJumpAMIFvPatchScalarField onto a
        //  new patch
        energyJumpAMIFvPatchScalargpuField
        (
            const energyJumpAMIFvPatchScalargpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        energyJumpAMIFvPatchScalargpuField
        (
            const energyJumpAMIFvPatchScalargpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchgpuField<scalar>> clone() const
        {
            return tmp<fvPatchgpuField<scalar>>
            (
                new energyJumpAMIFvPatchScalargpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        energyJumpAMIFvPatchScalargpuField
        (
            const energyJumpAMIFvPatchScalargpuField&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchgpuField<scalar>> clone
        (
            const DimensionedgpuField<scalar, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchgpuField<scalar>>
            (
                new energyJumpAMIFvPatchScalargpuField(*this, iF)
            );
        }


    // Member functions

        // Evaluation functions

            //- Update the coefficients
            virtual void updateCoeffs();


        //- Write
        virtual void write(Ostream&) const;
};

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
