/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2012-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::energyJumpFvPatchScalarField

Group
    grpThermoBoundaryConditions grpCoupledBoundaryConditions

Description
    This boundary condition provides an energy jump condition across a pair
    of coupled patches.  It is not applied directly, but is employed on-the-fly
    when converting temperature boundary conditions into energy.

See also
    Foam::fixedJumpFvPatchField

SourceFiles
    energyJumpFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef energyJumpFvPatchScalargpuField_H
#define energyJumpFvPatchScalargpuField_H

#include "fixedJumpFvPatchgpuField.H"
#include "Function1.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                Class energyJumpFvPatchScalarField Declaration
\*---------------------------------------------------------------------------*/

class energyJumpFvPatchScalargpuField
:
    public fixedJumpFvPatchgpuField<scalar>
{

public:

    //- Runtime type information
    TypeName("energyJump");

    // Constructors

        //- Construct from patch and internal field
        energyJumpFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        energyJumpFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given energyJumpFvPatchScalarField onto a
        //  new patch
        energyJumpFvPatchScalargpuField
        (
            const energyJumpFvPatchScalargpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        energyJumpFvPatchScalargpuField
        (
            const energyJumpFvPatchScalargpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchgpuField<scalar>> clone() const
        {
            return tmp<fvPatchgpuField<scalar>>
            (
                new energyJumpFvPatchScalargpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        energyJumpFvPatchScalargpuField
        (
            const energyJumpFvPatchScalargpuField&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchgpuField<scalar>> clone
        (
            const DimensionedgpuField<scalar, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchgpuField<scalar>>
            (
                new energyJumpFvPatchScalargpuField(*this, iF)
            );
        }


    // Member functions

        // Evaluation functions

            //- Update the coefficients
            virtual void updateCoeffs();


        //- Write
        virtual void write(Ostream&) const;
};

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
