/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fixedValueFvsPatchgpuField

Description
    Foam::fixedValueFvsPatchgpuField

SourceFiles
    fixedValueFvsPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef fixedValueFvsPatchgpuField_H
#define fixedValueFvsPatchgpuField_H

#include "fvsPatchgpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                           Class fixedValueFvsPatch Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class fixedValueFvsPatchgpuField
:
    public fvsPatchgpuField<Type>
{

public:

    //- Runtime type information
    TypeName("fixedValue");


    // Constructors

        //- Construct from patch and internal field
        fixedValueFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct from patch, internal field and dictionary
        fixedValueFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const dictionary&
        );

        //- Construct by mapping the given fixedValueFvsPatchgpuField<Type>
        //  onto a new patch
        fixedValueFvsPatchgpuField
        (
            const fixedValueFvsPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        fixedValueFvsPatchgpuField
        (
            const fixedValueFvsPatchgpuField<Type>&
        );

        //- Construct and return a clone
        virtual tmp<fvsPatchgpuField<Type>> clone() const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new fixedValueFvsPatchgpuField<Type>(*this)
            );
        }

        //- Construct as copy setting internal field reference
        fixedValueFvsPatchgpuField
        (
            const fixedValueFvsPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvsPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpusurfaceMesh>& iF
        ) const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new fixedValueFvsPatchgpuField<Type>(*this, iF)
            );
        }


    // Member functions

        // Access

            //- Return true if this patch field fixes a value.
            //  Needed to check if a level has to be specified while solving
            //  Poissons equations.
            virtual bool fixesValue() const
            {
                return true;
            }


        // Evaluation functions

            //- Return the matrix diagonal coefficients corresponding to the
            //  evaluation of the value of this patchField with given weights
            virtual tmp<gpuField<Type>> valueInternalCoeffs
            (
                const tmp<scalargpuField>&
            ) const;

            //- Return the matrix source coefficients corresponding to the
            //  evaluation of the value of this patchField with given weights
            virtual tmp<gpuField<Type>> valueBoundaryCoeffs
            (
                const tmp<scalargpuField>&
            ) const;

            //- Return the matrix diagonal coefficients corresponding to the
            //  evaluation of the gradient of this patchField
            virtual tmp<gpuField<Type>> gradientInternalCoeffs() const;

            //- Return the matrix source coefficients corresponding to the
            //  evaluation of the gradient of this patchField
            virtual tmp<gpuField<Type>> gradientBoundaryCoeffs() const;


    // Member operators

        virtual void operator=(const UList<Type>&) {}
        virtual void operator=(const gpuList<Type>&) {}

        virtual void operator=(const fvsPatchgpuField<Type>&) {}
        virtual void operator+=(const fvsPatchgpuField<Type>&) {}
        virtual void operator-=(const fvsPatchgpuField<Type>&) {}
        virtual void operator*=(const fvsPatchgpuField<scalar>&) {}
        virtual void operator/=(const fvsPatchgpuField<scalar>&) {}

        virtual void operator+=(const gpuField<Type>&) {}
        virtual void operator-=(const gpuField<Type>&) {}

        virtual void operator*=(const gpuField<scalar>&) {}
        virtual void operator/=(const gpuField<scalar>&) {}

        virtual void operator=(const Type&) {}
        virtual void operator+=(const Type&) {}
        virtual void operator-=(const Type&) {}
        virtual void operator*=(const scalar) {}
        virtual void operator/=(const scalar) {}
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "fixedValueFvsPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
