/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fv::multivariateGaussConvectionScheme

Group
    grpFvConvectionSchemes

Description
    Basic second-order convection using face-gradients and Gauss' theorem.

SourceFiles
    multivariateGaussConvectionScheme.C

\*---------------------------------------------------------------------------*/

#ifndef gpumultivariateGaussConvectionScheme_H
#define gpumultivariateGaussConvectionScheme_H

#include "gpuconvectionScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fv
{

/*---------------------------------------------------------------------------*\
                       Class multivariateGaussConvectionScheme Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class gpumultivariateGaussConvectionScheme
:
    public fv::gpuconvectionScheme<Type>
{
    // Private data

        tmp<gpumultivariateSurfaceInterpolationScheme<Type>> tinterpScheme_;


public:

    //- Runtime type information
    TypeName("Gauss");


    // Constructors

        //- Construct from flux and Istream
        gpumultivariateGaussConvectionScheme
        (
            const gpufvMesh& mesh,
            const typename gpumultivariateSurfaceInterpolationScheme<Type>::
                fieldTable& fields,
            const surfaceScalargpuField& faceFlux,
            Istream& is
        )
        :
            gpuconvectionScheme<Type>(mesh, faceFlux),
            tinterpScheme_
            (
                gpumultivariateSurfaceInterpolationScheme<Type>::New
                (
                    mesh, fields, faceFlux, is
                )
            )
        {}


    // Member Functions

        tmp<gpumultivariateSurfaceInterpolationScheme<Type>>
        interpolationScheme() const
        {
            return tinterpScheme_;
        }

        tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;

        tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> flux
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;

        tmp<gpufvMatrix<Type>> fvmDiv
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;

        tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> fvcDiv
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fv

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpumultivariateGaussConvectionScheme.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
