/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "processorCyclicGGAMGInterface.H"
#include "addToRunTimeSelectionTable.H"
#include "Map.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeNameAndDebug(processorCyclicGGAMGInterface, 0);
    addToRunTimeSelectionTable
    (
        GGAMGInterface,
        processorCyclicGGAMGInterface,
        gpulduInterface
    );
    addToRunTimeSelectionTable
    (
        GGAMGInterface,
        processorCyclicGGAMGInterface,
        Istream
    );
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::processorCyclicGGAMGInterface::processorCyclicGGAMGInterface
(
    const label index,
    const gpulduInterfacePtrsList& coarseInterfaces,
    const gpulduInterface& fineInterface,
    const labelField& localRestrictAddressing,
    const labelField& neighbourRestrictAddressing,
    const label fineLevelIndex,
    const label coarseComm
)
:
    processorGGAMGInterface
    (
        index,
        coarseInterfaces,
        fineInterface,
        localRestrictAddressing,
        neighbourRestrictAddressing,
        fineLevelIndex,
        coarseComm
    )
{}


Foam::processorCyclicGGAMGInterface::processorCyclicGGAMGInterface
(
    const label index,
    const gpulduInterfacePtrsList& coarseInterfaces,
    Istream& is
)
:
    processorGGAMGInterface(index, coarseInterfaces, is)
{}


// ************************************************************************* //
