/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
    Copyright (C) 2019-2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "GGAMGInterface.H"
#include "GGAMGAgglomeration.H"
#include "gpulduMatrix.H"


// * * * * * * * * * * * * * * * * Selectors * * * * * * * * * * * * * * * * //

Foam::autoPtr<Foam::GGAMGInterface> Foam::GGAMGInterface::New
(
    const label index,
    const gpulduInterfacePtrsList& coarseInterfaces,
    const gpulduInterface& fineInterface,
    const labelField& localRestrictAddressing,
    const labelField& neighbourRestrictAddressing,
    const label fineLevelIndex,
    const label coarseComm
)
{
    const word coupleType(fineInterface.type());

    auto* ctorPtr = gpulduInterfaceConstructorTable(coupleType);

    if (!ctorPtr)
    {
        FatalErrorInLookup
        (
            "GGAMGInterface",
            coupleType,
            *gpulduInterfaceConstructorTablePtr_
        ) << exit(FatalError);
    }

    return autoPtr<GGAMGInterface>
    (
        ctorPtr
        (
            index,
            coarseInterfaces,
            fineInterface,
            localRestrictAddressing,
            neighbourRestrictAddressing,
            fineLevelIndex,
            coarseComm
        )
    );
}


Foam::autoPtr<Foam::GGAMGInterface> Foam::GGAMGInterface::New
(
    const word& coupleType,
    const label index,
    const gpulduInterfacePtrsList& coarseInterfaces,
    Istream& is
)
{
    auto* ctorPtr = IstreamConstructorTable(coupleType);

    if (!ctorPtr)
    {
        FatalErrorInLookup
        (
            "GGAMGInterface",
            coupleType,
            *IstreamConstructorTablePtr_
        ) << exit(FatalError);
    }

    return autoPtr<GGAMGInterface>(ctorPtr(index, coarseInterfaces, is));
}


// ************************************************************************* //
