/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "cyclicGGAMGInterfaceField.H"
#include "addToRunTimeSelectionTable.H"
#include "gpulduMatrix.H"

#include "GAMGInterfaceFunctors.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeNameAndDebug(cyclicGGAMGInterfaceField, 0);
    addToRunTimeSelectionTable
    (
        GGAMGInterfaceField,
        cyclicGGAMGInterfaceField,
        gpulduInterface
    );
    addToRunTimeSelectionTable
    (
        GGAMGInterfaceField,
        cyclicGGAMGInterfaceField,
        lduInterfacegpuField
    );

    // Add under name cyclicSlip
    addNamedToRunTimeSelectionTable
    (
        GGAMGInterfaceField,
        cyclicGGAMGInterfaceField,
        gpulduInterface,
        cyclicSlip
    );
    addNamedToRunTimeSelectionTable
    (
        GGAMGInterfaceField,
        cyclicGGAMGInterfaceField,
        lduInterfacegpuField,
        cyclicSlip
    );
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::cyclicGGAMGInterfaceField::cyclicGGAMGInterfaceField
(
    const GGAMGInterface& GAMGCp,
    const lduInterfacegpuField& fineInterface
)
:
    GGAMGInterfaceField(GAMGCp, fineInterface),
    cyclicInterface_(refCast<const cyclicGGAMGInterface>(GAMGCp)),
    doTransform_(false),
    rank_(0)
{
    const cyclicLduInterfacegpuField& p =
        refCast<const cyclicLduInterfacegpuField>(fineInterface);

    doTransform_ = p.doTransform();
    rank_ = p.rank();
}


Foam::cyclicGGAMGInterfaceField::cyclicGGAMGInterfaceField
(
    const GGAMGInterface& GAMGCp,
    const bool doTransform,
    const int rank
)
:
    GGAMGInterfaceField(GAMGCp, doTransform, rank),
    cyclicInterface_(refCast<const cyclicGGAMGInterface>(GAMGCp)),
    doTransform_(doTransform),
    rank_(rank)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

/*void Foam::cyclicGGAMGInterfaceField::updateInterfaceMatrix
(
    solveScalarField& result,
    const bool add,
    const gpulduAddressing& lduAddr,
    const label patchId,
    const solveScalarField& psiInternal,
    const scalarField& coeffs,
    const direction cmpt,
    const Pstream::commsTypes
) const
{
    // Get neighbouring field

    const labelList& nbrFaceCells =
        lduAddr.patchAddr
        (
            cyclicInterface_.neighbPatchID()
        );

    solveScalarField pnf(psiInternal, nbrFaceCells);

    transformCoupleField(pnf, cmpt);

    const labelList& faceCells = lduAddr.patchAddr(patchId);

    this->addToInternalField(result, !add, faceCells, coeffs, pnf);
}*/


void Foam::cyclicGGAMGInterfaceField::updateInterfaceMatrix
(
    scalargpuField& result,
    const bool add,
    const gpulduAddressing& lduAddr,
    const label patchId,
    const scalargpuField& psiInternal,
    const scalargpuField& coeffs,
    const direction cmpt,
    const Pstream::commsTypes
) const
{
    // Get neighbouring field
    const labelgpuList& nbrFaceCells =
        lduAddr.patchAddr
        (
            cyclicInterface_.neighbPatchID()
        );

    scalargpuField pnf(psiInternal, nbrFaceCells);

    transformCoupleField(pnf, cmpt);

    GAMGUpdateInterfaceMatrix
    (
        result,
        coeffs,
        pnf,
        cyclicInterface_,
        !add
    );
}

// ************************************************************************* //
