/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Description
    Fundamental dimensioned constants

\*---------------------------------------------------------------------------*/

#ifndef gpufundamentalConstants_H
#define gpufundamentalConstants_H

#include "scalar.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace constant
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace universal
{
    //- Speed of light in a vacuum
    __constant__  scalar gc;

    //- Newtonian constant of gravitation
    __constant__  scalar gG;

    //- Planck constant
    __constant__  scalar gh;
}

namespace electromagnetic
{
    //- Elementary charge
    __constant__  scalar ge;
}

namespace atomic
{
    //- Electron mass
    __constant__  scalar gme;

    //- Proton mass
    __constant__  scalar gmp;
}

namespace physicoChemical
{
    //- Atomic mass unit
    __constant__  scalar gmu;

    //- Avagadro number
    __constant__  scalar gNA;

    //- Boltzmann constant
    __constant__  scalar gk;
}

//- Standard values
namespace standard
{
    //- Standard pressure
    __constant__  scalar gPstd;

    //- Standard temperature
    __constant__  scalar gTstd;
}

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace constant
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
